/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldName;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ObjectClassField_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.AtNotation;
import org.eclipse.titan.designer.AST.AtNotations;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.Constraint;
import org.eclipse.titan.designer.AST.Constraints;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class TableConstraint
extends Constraint {
    private static final String FULLNAMEPART = ".<tableconstraint-os>";
    private static final String OCFTEXPECTED = "TableConstraint can only be applied to ObjectClassFieldType";
    private static final String CANNOTDETERMINEPARENT = "Invalid use of ComponentRelationConstraint (cannot determine parent type)";
    private static final String TOOMANYDOTS = "Too many dots. This component has only {0} parameters.";
    private static final String NOCOMPONENTERROR = "Type `{0}'' has no component with name `{1}''.";
    private static final String SECHOEXPECTED = "Type `{0}'' is not a SEQUENCE, SET or CHOICE type";
    private static final String SAMECONSTRAINTEXPECTED = "The referenced components must be value (set) fields constrained by the same objectset as the referencing component";
    private Block mObjectSetBlock;
    private Block mAtNotationsBlock;
    protected ObjectSet objectSet;
    protected AtNotations atNotationList;
    private Identifier objectClassFieldname;
    private IType constrainedType;

    public TableConstraint(Block aObjectSetBlock, Block aAtNotationsBlock) {
        super(Constraint.Constraint_type.CT_TABLE);
        this.mObjectSetBlock = aObjectSetBlock;
        this.mAtNotationsBlock = aAtNotationsBlock;
    }

    @Override
    public TableConstraint newInstance() {
        return new TableConstraint(this.mObjectSetBlock, this.mAtNotationsBlock);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        block35: {
            if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
                return;
            }
            this.lastTimeChecked = timestamp;
            this.parseBlocks();
            if (null == this.myType) {
                return;
            }
            this.objectSet.setMyScope(this.myType.getMyScope());
            BridgingNamedNode bridge = new BridgingNamedNode(this, FULLNAMEPART);
            this.objectSet.setFullNameParent(bridge);
            this.constrainedType = this.myType;
            while (true) {
                if (this.constrainedType.getIsErroneous(timestamp)) {
                    return;
                }
                if (IType.Type_type.TYPE_OPENTYPE.equals((Object)this.constrainedType.getTypetype()) || IType.Type_type.TYPE_OBJECTCLASSFIELDTYPE.equals((Object)this.constrainedType.getTypetype())) break block35;
                if (!(this.constrainedType instanceof IReferencingType)) break;
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                this.constrainedType = ((IReferencingType)((Object)this.constrainedType)).getTypeRefd(timestamp, chain);
                chain.release();
            }
            this.myType.getLocation().reportSemanticError(OCFTEXPECTED);
            return;
        }
        if (IType.Type_type.TYPE_OBJECTCLASSFIELDTYPE.equals((Object)this.constrainedType.getTypetype())) {
            ObjectClassField_Type ocfType = (ObjectClassField_Type)this.constrainedType;
            this.objectClassFieldname = ocfType.getObjectClassFieldName();
            this.objectSet.setMyGovernor(ocfType.getMyObjectClass());
            this.objectSet.check(timestamp);
            return;
        }
        Open_Type openType = (Open_Type)this.constrainedType;
        openType.setMyTableConstraint(this);
        this.objectClassFieldname = openType.getObjectClassFieldName();
        this.objectSet.setMyGovernor(openType.getMyObjectClass());
        this.objectSet.check(timestamp);
        if (null == this.atNotationList) {
            return;
        }
        Type outermostParent = null;
        IType tempType = this.myType;
        do {
            switch (tempType.getTypetype()) {
                case TYPE_ASN1_CHOICE: 
                case TYPE_TTCN3_CHOICE: 
                case TYPE_OPENTYPE: 
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_ASN1_SET: 
                case TYPE_TTCN3_SET: {
                    outermostParent = tempType;
                    break;
                }
            }
        } while (null != (tempType = tempType.getParentType()));
        if (null == outermostParent) {
            this.myType.getLocation().reportSemanticError(CANNOTDETERMINEPARENT);
            return;
        }
        for (int i = 0; i < this.atNotationList.getNofAtNotations(); ++i) {
            AtNotation atNotation = this.atNotationList.getAtNotationByIndex(i);
            IType parent = null;
            if (0 == atNotation.getLevels()) {
                parent = outermostParent;
            } else {
                parent = this.myType;
                for (int level = atNotation.getLevels(); level > 0; --level) {
                    if (null != (parent = parent.getParentType())) continue;
                    this.myType.getLocation().reportSemanticError(MessageFormat.format(TOOMANYDOTS, atNotation.getLevels()));
                    return;
                }
            }
            tempType = parent;
            atNotation.setFirstComponent(parent);
            FieldName componentIdentifiers = atNotation.getComponentIdentifiers();
            block16: for (int j = 0; j < componentIdentifiers.getNofFields(); ++j) {
                Identifier identifier = componentIdentifiers.getFieldByIndex(i);
                switch (tempType.getTypetype()) {
                    case TYPE_ASN1_CHOICE: {
                        Type temp2 = (ASN1_Choice_Type)tempType;
                        if (((ASN1_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier)) {
                            tempType = ((ASN1_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_TTCN3_CHOICE: {
                        Type temp2 = (TTCN3_Choice_Type)tempType;
                        if (((TTCN3_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier.getName())) {
                            tempType = ((TTCN3_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier.getName()).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_OPENTYPE: {
                        Type temp2 = (Open_Type)tempType;
                        if (((Open_Type)temp2).hasComponentWithName(identifier)) {
                            tempType = ((Open_Type)temp2).getComponentByName(identifier).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        Type temp2 = (ASN1_Sequence_Type)tempType;
                        if (((ASN1_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier)) {
                            tempType = ((ASN1_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_TTCN3_SEQUENCE: {
                        Type temp2 = (TTCN3_Sequence_Type)tempType;
                        if (((TTCN3_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier.getName())) {
                            tempType = ((TTCN3_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier.getName()).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_ASN1_SET: {
                        Type temp2 = (ASN1_Set_Type)tempType;
                        if (((ASN1_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier)) {
                            tempType = ((ASN1_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    case TYPE_TTCN3_SET: {
                        Type temp2 = (TTCN3_Set_Type)tempType;
                        if (((TTCN3_Set_Seq_Choice_BaseType)temp2).hasComponentWithName(identifier.getName())) {
                            tempType = ((TTCN3_Set_Seq_Choice_BaseType)temp2).getComponentByName(identifier.getName()).getType();
                            continue block16;
                        }
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(NOCOMPONENTERROR, tempType.getFullName(), identifier.getDisplayName()));
                        return;
                    }
                    default: {
                        this.myType.getLocation().reportSemanticError(MessageFormat.format(SECHOEXPECTED, tempType.getFullName()));
                        return;
                    }
                }
            }
            atNotation.setLastComponent(tempType);
            boolean ok = false;
            Constraints constraints = tempType.getConstraints();
            if (constraints != null) {
                IType ocft;
                constraints.check(timestamp);
                TableConstraint tableConstraint = constraints.getTableConstraint();
                if (tableConstraint != null && IType.Type_type.TYPE_OBJECTCLASSFIELDTYPE.equals((Object)(ocft = tableConstraint.constrainedType).getTypetype())) {
                    atNotation.setObjectClassFieldname(((ObjectClassField_Type)ocft).getObjectClassFieldName());
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    ObjectSet_definition osdef1 = tableConstraint.objectSet.getRefdLast(timestamp, chain);
                    chain.release();
                    chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    ObjectSet_definition osdef2 = this.objectSet.getRefdLast(timestamp, chain);
                    chain.release();
                    if (osdef1 == osdef2) {
                        ok = true;
                    }
                }
            }
            if (ok) continue;
            this.myType.getLocation().reportSemanticError(SAMECONSTRAINTEXPECTED);
            return;
        }
    }

    private void parseBlocks() {
        if (this.mObjectSetBlock == null) {
            return;
        }
        this.objectSet = null;
        this.atNotationList = null;
        if (null != this.mObjectSetBlock) {
            if (this.mAtNotationsBlock == null) {
                Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mObjectSetBlock, 0);
                if (parser != null) {
                    this.objectSet = parser.pr_special_ObjectSetSpec().definition;
                    List<SyntacticErrorStorage> errors = parser.getErrorStorage();
                    if (null != errors && !errors.isEmpty()) {
                        this.objectSet = null;
                        for (int i = 0; i < errors.size(); ++i) {
                            ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mObjectSetBlock.getLocation().getFile(), errors.get(i), 2);
                        }
                    }
                }
            } else {
                int i;
                List<SyntacticErrorStorage> errors;
                Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mObjectSetBlock, 0);
                if (parser != null) {
                    this.objectSet = parser.pr_DefinedObjectSetBlock().objectSet;
                    errors = parser.getErrorStorage();
                    if (null != errors && !errors.isEmpty()) {
                        this.objectSet = null;
                        for (i = 0; i < errors.size(); ++i) {
                            ParserMarkerSupport.createOnTheFlySyntacticMarker((IFile)this.mObjectSetBlock.getLocation().getFile(), errors.get(i), 2);
                        }
                    }
                }
                if ((parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mAtNotationsBlock, 0)) != null) {
                    this.atNotationList = parser.pr_AtNotationList().notationList;
                    errors = parser.getErrorStorage();
                    if (null != errors && !errors.isEmpty()) {
                        this.objectSet = null;
                        for (i = 0; i < errors.size(); ++i) {
                            ParserMarkerSupport.createOnTheFlySyntacticMarker((IFile)this.mAtNotationsBlock.getLocation().getFile(), errors.get(i), 2);
                        }
                    }
                }
                if (this.atNotationList == null) {
                    this.atNotationList = new AtNotations();
                }
            }
        }
        if (this.objectSet == null) {
            this.objectSet = new ObjectSet_definition();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

