/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private static final int ERRORTICK_BUILDPATH_ERROR = 8192;
    private static final int ERRORTICK_IGNORE_OPTIONAL_PROBLEMS = 32768;
    private static final int ERRORTICK_INFO = 262144;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList<ILabelProviderListener> fListeners;
    private ISourceRange fCachedRange;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        if (image == null) {
            return null;
        }
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object obj) {
        block17: {
            try {
                if (obj instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)obj;
                    int type = element.getElementType();
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 3: {
                            int flags = this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                            switch (type) {
                                case 3: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                                    if (flags == 64 || root.getKind() != 1 || !this.isIgnoringOptionalProblems(root.getRawClasspathEntry())) break;
                                    flags = 32768;
                                    break;
                                }
                                case 2: {
                                    IJavaProject project = (IJavaProject)element;
                                    if (flags == 64 || flags == 8192 || !this.isIgnoringOptionalProblems(project)) break;
                                    flags = 32768;
                                }
                            }
                            return flags;
                        }
                        case 4: {
                            return this.getPackageErrorTicksFromMarkers((IPackageFragment)element);
                        }
                        case 5: 
                        case 6: {
                            return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                            if (cu != null) {
                                ISourceReference ref = type == 5 ? null : (ISourceReference)element;
                                IAnnotationModel model = this.isInJavaAnnotationModel(cu);
                                int result = 0;
                                result = model != null ? this.getErrorTicksFromAnnotationModel(model, ref) : this.getErrorTicksFromMarkers(cu.getResource(), 1, ref);
                                this.fCachedRange = null;
                                return result;
                            }
                            break block17;
                        }
                    }
                    break block17;
                }
                if (obj instanceof IResource) {
                    return this.getErrorTicksFromMarkers((IResource)obj, 2, null);
                }
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException && ((JavaModelException)((Object)e)).isDoesNotExist()) {
                    return 0;
                }
                if (e.getStatus().getCode() == 376) {
                    return 0;
                }
                JavaPlugin.log(e);
            }
        }
        return 0;
    }

    private boolean isIgnoringOptionalProblems(IClasspathEntry entry) {
        if (entry.getEntryKind() == 3) {
            IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
            int i = 0;
            while (i < extraAttributes.length) {
                IClasspathAttribute attrib = extraAttributes[i];
                if ("ignore_optional_problems".equals(attrib.getName())) {
                    return "true".equals(attrib.getValue());
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isIgnoringOptionalProblems(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IPath projectPath = project.getPath();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = project.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && projectPath.equals((Object)entry.getPath()) && this.isIgnoringOptionalProblems(entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int severity = -1;
        if (sourceElement == null) {
            if (res instanceof IProject) {
                severity = res.findMaxProblemSeverity("org.eclipse.jdt.core.buildpath_problem", true, 0);
                if (severity == 2) {
                    return 8192;
                }
                severity = res.findMaxProblemSeverity(JavaRuntime.JRE_CONTAINER_MARKER, true, 0);
                if (severity == 2) {
                    return 8192;
                }
            }
            severity = res.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, depth);
        } else {
            IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length && severity != 2) {
                    int val;
                    IMarker curr = markers[i];
                    if (this.isMarkerInRange(curr, sourceElement) && ((val = curr.getAttribute("severity", -1)) == 0 || val == 1 || val == 2)) {
                        severity = val;
                    }
                    ++i;
                }
            }
        }
        if (severity == 2) {
            return 64;
        }
        if (severity == 1) {
            return 32;
        }
        if (severity == 0) {
            return 262144;
        }
        return 0;
    }

    private int getPackageErrorTicksFromMarkers(IPackageFragment pack) throws CoreException {
        IResource res = pack.getResource();
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int severity = res.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0);
        if (severity == 2) {
            return 64;
        }
        Object[] objectArray = pack.getCompilationUnits();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = objectArray[n2];
            if ((severity = Math.max(severity, cu.getResource().findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0))) == 2) {
                return 64;
            }
            ++n2;
        }
        objectArray = pack.getNonJavaResources();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IResource resource;
            ICompilationUnit object = objectArray[n2];
            if (object instanceof IResource && (severity = Math.max(severity, (resource = (IResource)object).findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2))) == 2) {
                return 64;
            }
            ++n2;
        }
        if (severity == 1) {
            return 32;
        }
        if (severity == 0) {
            return 262144;
        }
        return 0;
    }

    private boolean isMarkerInRange(IMarker marker, ISourceReference sourceElement) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int pos = marker.getAttribute("charStart", -1);
            return this.isInside(pos, sourceElement);
        }
        return false;
    }

    private IAnnotationModel isInJavaAnnotationModel(ICompilationUnit original) {
        if (original.isWorkingCopy()) {
            FileEditorInput editorInput = new FileEditorInput((IFile)original.getResource());
            return JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(editorInput);
        }
        return null;
    }

    private int getErrorTicksFromAnnotationModel(IAnnotationModel model, ISourceReference sourceElement) throws CoreException {
        int info = 0;
        Iterator iter = model.getAnnotationIterator();
        while (info != 64 && iter.hasNext()) {
            Annotation annot = (Annotation)iter.next();
            IMarker marker = this.isAnnotationInRange(model, annot, sourceElement);
            if (marker == null) continue;
            int priority = marker.getAttribute("severity", -1);
            if (priority == 0) {
                info = 262144;
                continue;
            }
            if (priority == 1) {
                info = 32;
                continue;
            }
            if (priority != 2) continue;
            info = 64;
        }
        return info;
    }

    private IMarker isAnnotationInRange(IAnnotationModel model, Annotation annot, ISourceReference sourceElement) throws CoreException {
        IMarker marker;
        if (annot instanceof MarkerAnnotation && (sourceElement == null || this.isInside(model.getPosition(annot), sourceElement)) && (marker = ((MarkerAnnotation)annot).getMarker()).exists() && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return marker;
        }
        return null;
    }

    private boolean isInside(Position pos, ISourceReference sourceElement) throws CoreException {
        return pos != null && this.isInside(pos.getOffset(), sourceElement);
    }

    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        ISourceRange range;
        if (this.fCachedRange == null) {
            this.fCachedRange = sourceElement.getSourceRange();
        }
        if ((range = this.fCachedRange) != null) {
            int rangeOffset = range.getOffset();
            return rangeOffset <= pos && rangeOffset + range.getLength() > pos;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                @Override
                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            JavaPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            for (ILabelProviderListener listener : this.fListeners) {
                listener.labelProviderChanged((LabelProviderChangedEvent)event);
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 8192) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_BUILDPATH_ERROR);
        } else if (adornmentFlags == 32) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_WARNING);
        } else if (adornmentFlags == 262144) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_INFO);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

