/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementDeclaredTypeHyperlink;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class JavaElementHyperlinkDeclaredTypeDetector
extends JavaElementHyperlinkDetector {
    @Override
    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        try {
            String typeSignature;
            if ((element.getElementType() == 8 || element.getElementType() == 14) && !JavaModelUtil.isPrimitive(typeSignature = JavaElementHyperlinkDeclaredTypeDetector.getTypeSignature(element)) && SelectionConverter.canOperateOn(editor)) {
                if (Signature.getTypeSignatureKind((String)typeSignature) == 7) {
                    String[] bounds = Signature.getIntersectionTypeBounds((String)typeSignature);
                    qualify |= bounds.length >= 2;
                    int i = 0;
                    while (i < bounds.length) {
                        hyperlinksCollector.add(new JavaElementDeclaredTypeHyperlink(wordRegion, openAction, element, bounds[i], qualify));
                        ++i;
                    }
                } else {
                    hyperlinksCollector.add(new JavaElementDeclaredTypeHyperlink(wordRegion, openAction, element, qualify));
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    static String getTypeSignature(IJavaElement element) throws JavaModelException {
        if (element instanceof ILocalVariable) {
            return ((ILocalVariable)element).getTypeSignature();
        }
        if (element instanceof IField) {
            return ((IField)element).getTypeSignature();
        }
        throw new IllegalArgumentException();
    }
}

