/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.StatColumn;
import org.eclipse.titanium.metrics.risk.IRisk;

public class Statistics {
    private final Map<StatColumn, Double> columns;
    private final Double highestRisk;

    public Statistics(double[] nums, IMetricEnum metric, IRisk risk) {
        double dev;
        double mean;
        double max;
        int n = nums.length;
        double total = 0.0;
        Set<StatColumn> stats = metric.requestedStatistics();
        boolean isInt = metric.isInteger();
        this.columns = new EnumMap<StatColumn, Double>(StatColumn.class);
        if (n == 0) {
            max = 0.0;
            mean = 0.0;
            dev = 0.0;
            this.highestRisk = null;
        } else {
            double ssum = 0.0;
            double highest = nums[0];
            max = nums[0];
            for (double i : nums) {
                total += i;
                ssum += i * i;
                max = max < i ? i : max;
                highest = risk.getRiskValue(i) > risk.getRiskValue(highest) ? i : highest;
            }
            mean = total / (double)n;
            dev = Math.sqrt(ssum / (double)n - mean * mean);
            Double d = this.highestRisk = metric.isInteger() ? new Double(Math.round(highest)) : new Double(highest);
        }
        if (stats.contains((Object)StatColumn.TOTAL)) {
            Double tmpT = isInt ? new Double(Math.round(total)) : new Double(total);
            this.columns.put(StatColumn.TOTAL, tmpT);
        }
        if (stats.contains((Object)StatColumn.MAX)) {
            Double tmpM = isInt ? new Double(Math.round(max)) : new Double(max);
            this.columns.put(StatColumn.MAX, tmpM);
        }
        if (stats.contains((Object)StatColumn.MEAN)) {
            this.columns.put(StatColumn.MEAN, new Double(mean));
        }
        if (stats.contains((Object)StatColumn.DEV)) {
            this.columns.put(StatColumn.DEV, new Double(dev));
        }
    }

    public Number get(StatColumn column) {
        return this.columns.get((Object)column);
    }

    public Number getHighestRisk() {
        return this.highestRisk;
    }
}

