/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils.environment;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvironmentVariableResolver {
    private Pattern pattern;
    private String variableStart;
    private String variableEnd;

    private EnvironmentVariableResolver(Pattern pattern, String variableStart, String variableEnd) {
        this.pattern = pattern;
        this.variableStart = variableStart;
        this.variableEnd = variableEnd;
    }

    public static EnvironmentVariableResolver eclipseStyle() {
        return new EnvironmentVariableResolver(Pattern.compile("\\[.*?\\]"), "[", "]");
    }

    public static EnvironmentVariableResolver unixStyle() {
        return new EnvironmentVariableResolver(Pattern.compile("\\$\\{.*?\\}"), "${", "}");
    }

    public String resolve(String original, Map<?, ?> envVariables) throws VariableNotFoundException {
        try {
            return this.resolve(original, envVariables, false);
        }
        catch (IllegalArgumentException e) {
            throw new VariableNotFoundException(e.getMessage());
        }
    }

    public String resolveIgnoreErrors(String original, Map<?, ?> envVariables) {
        return this.resolve(original, envVariables, true);
    }

    private String resolve(String original, Map<?, ?> envVariables, boolean ignoreErrors) {
        Matcher matcher = this.pattern.matcher(original);
        StringBuffer builder = new StringBuffer(original.length());
        boolean result2 = matcher.find();
        while (result2) {
            String keyWithStartEnd = matcher.group();
            String key = keyWithStartEnd.substring(this.variableStart.length(), keyWithStartEnd.length() - 1);
            if (envVariables.containsKey(key)) {
                String result3 = (String)envVariables.get(key);
                matcher.appendReplacement(builder, result3.replace("\\", "\\\\").replace("$", "\\$"));
            } else if (ignoreErrors) {
                matcher.appendReplacement(builder, Matcher.quoteReplacement(this.variableStart) + key + Matcher.quoteReplacement(this.variableEnd));
            } else {
                throw new IllegalArgumentException(keyWithStartEnd);
            }
            result2 = matcher.find();
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static class VariableNotFoundException
    extends Exception {
        public VariableNotFoundException(String variableName) {
            super("Variable " + variableName + " cannot be resolved.");
        }
    }
}

