/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;

public final class ConfigTreeNodeUtilities {
    private ConfigTreeNodeUtilities() {
    }

    public static String toString(ParseTree aRoot) {
        return aRoot.getText();
    }

    public static void addChild(ParseTree aParent, ParseTree aChild) {
        ConfigTreeNodeUtilities.addChild(aParent, aChild, -1);
    }

    public static void addChild(ParseTree aParent, ParseTree aChild, int aIndex) {
        if (aParent == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.addChild(): aParent == null");
            return;
        }
        if (aChild == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.addChild(): aChild == null");
            return;
        }
        if (aParent == aChild) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.addChild(): aParent == aChild");
            return;
        }
        if (aParent instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aParent;
            if (rule.children == null) {
                rule.children = new ArrayList();
            }
            if (aIndex >= 0) {
                rule.children.set(aIndex, aChild);
            } else {
                rule.children.add(aChild);
            }
            ConfigTreeNodeUtilities.setParent(aChild, rule);
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.addChild(): only ParserRuleContext can have children");
        }
    }

    private static void setParent(ParseTree aChild, ParserRuleContext aParent) {
        if (aChild == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setParent(): aChild == null");
            return;
        }
        if (aChild == aParent) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setParent(): aChild == aParent");
            return;
        }
        if (aChild instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aChild;
            rule.parent = aParent;
        } else if (aChild instanceof TerminalNodeImpl) {
            TerminalNodeImpl tn = (TerminalNodeImpl)aChild;
            tn.parent = aParent;
        } else if (aChild instanceof AddedParseTree) {
            AddedParseTree t = (AddedParseTree)aChild;
            t.setParent((ParseTree)aParent);
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setParent(): unhandled ParseTree class type");
        }
    }

    public static void removeChild(ParseTree aChild) {
        if (aChild == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChild( ParseTree ): aChild == null");
            return;
        }
        ParseTree parent = aChild.getParent();
        ConfigTreeNodeUtilities.removeChild(parent, aChild, false);
    }

    public static void removeChild(ParseTree aParent, ParseTree aChild) {
        ConfigTreeNodeUtilities.removeChild(aParent, aChild, true);
    }

    private static void removeChild(ParseTree aParent, ParseTree aChild, boolean aRetry) {
        if (aParent == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChild( ParseTree, ParseTree ): aParent == null");
            return;
        }
        if (aChild == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChild( ParseTree, ParseTree ): aChild == null");
            return;
        }
        if (aParent instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aParent;
            if (rule.children != null && aChild != null && aChild.getText() != null) {
                List list = rule.children;
                int size = list.size();
                String childText = aChild.getText();
                boolean found = false;
                for (int i = 0; i < size; ++i) {
                    if (!childText.equals(((ParseTree)list.get(i)).getText())) continue;
                    list.remove(i);
                    found = true;
                    break;
                }
                if (aRetry && !found) {
                    ConfigTreeNodeUtilities.removeChild(aChild);
                }
            }
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChild( ParseTree, ParseTree ): only ParserRuleContext can have children");
        }
    }

    public static void removeChildWithSeparator(ParseTree aParent, ParseTree aChild) {
        ConfigTreeNodeUtilities.removeChildWithSeparator(aParent, aChild, "|", 0);
    }

    public static void removeChildWithSeparator(ParseTree aParent, ParseTree aChild, String aSeparator, int aStartIndex) {
        if (aParent == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChildWithSeparator( ParseTree, ParseTree ): aParent == null");
            return;
        }
        if (aParent instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aParent;
            if (rule.children != null && aChild != null && aChild.getText() != null) {
                List list = rule.children;
                int size = list.size();
                String childText = aChild.getText();
                for (int i = aStartIndex; i < size; ++i) {
                    ParseTree next;
                    if (!childText.equals(((ParseTree)list.get(i)).getText())) continue;
                    list.remove(i);
                    if (i > aStartIndex) {
                        ParseTree previous = (ParseTree)list.get(i - 1);
                        if (aSeparator.equals(previous.getText())) {
                            list.remove(i - 1);
                        }
                    } else if (size > aStartIndex + 1 && aSeparator.equals((next = (ParseTree)list.get(aStartIndex)).getText())) {
                        list.remove(aStartIndex);
                    }
                    break;
                }
            }
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.removeChild( ParseTree, ParseTree ): only ParserRuleContext can have children");
        }
    }

    public static void setText(ParseTree aParseTree, String aText) {
        if (aParseTree == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setText(): aParseTree == null");
            return;
        }
        if (aParseTree instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aParseTree;
            if (rule.children != null) {
                rule.children.clear();
            } else {
                rule.children = new ArrayList();
            }
            AddedParseTree newNode = new AddedParseTree(aText);
            ConfigTreeNodeUtilities.addChild((ParseTree)rule, newNode);
        } else if (aParseTree instanceof AddedParseTree) {
            AddedParseTree node = (AddedParseTree)aParseTree;
            node.setText(aText);
        } else if (aParseTree instanceof TerminalNodeImpl) {
            TerminalNodeImpl node = (TerminalNodeImpl)aParseTree;
            Token t = node.symbol;
            if (t instanceof WritableToken) {
                WritableToken ct = (WritableToken)t;
                ct.setText(aText);
            } else {
                ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setText(): unhandled token class type");
            }
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.setText(): unhandled ParseTree class type");
        }
    }

    public static TerminalNodeImpl createHiddenTokenNode(String aText) {
        return new TerminalNodeImpl((Token)new CommonToken(0, aText));
    }
}

