/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class LaunchShortcutOverviewPage
extends PDEFormPage
implements IHyperlinkListener {
    public LaunchShortcutOverviewPage(PDELauncherFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected final Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(text);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected final FormText createClient(Composite section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        text.addHyperlinkListener((IHyperlinkListener)this);
        return text;
    }

    public void linkActivated(HyperlinkEvent e) {
        int modeEnd;
        String href = (String)e.getHref();
        int modeStart = href.indexOf(46);
        if (modeStart != -1 && (modeEnd = href.indexOf(46, modeStart + 1)) != -1) {
            this.getPDELauncherEditor().launch(href.substring(modeEnd + 1), href.substring(modeStart + 1, modeEnd), this.getPDELauncherEditor().getPreLaunchRunnable(), this.getPDELauncherEditor().getLauncherHelper().getLaunchObject());
        }
    }

    protected abstract short getIndent();

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }

    protected final String getLauncherText(boolean osgi, String message) {
        IConfigurationElement[][] elements = this.getPDELauncherEditor().getLaunchers(osgi);
        StringBuffer buffer = new StringBuffer();
        String indent = Short.toString(this.getIndent());
        int i = 0;
        while (i < elements.length) {
            int j = 0;
            while (j < elements[i].length) {
                String mode = elements[i][j].getAttribute("mode");
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(mode);
                buffer.append("\" bindent=\"" + indent + "\"><a href=\"launchShortcut.");
                buffer.append(mode);
                buffer.append('.');
                buffer.append(elements[i][j].getAttribute("id"));
                buffer.append("\">");
                buffer.append(elements[i][j].getAttribute("label"));
                buffer.append("</a></li>");
                ++j;
            }
            ++i;
        }
        return NLS.bind((String)message, (Object)buffer.toString());
    }

    protected PDELauncherFormEditor getPDELauncherEditor() {
        return (PDELauncherFormEditor)this.getPDEEditor();
    }
}

