/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import net.claribole.zgrviewer.Vector2D;

class PolyLine {
    ArrayList<Line2D> segments = new ArrayList();
    ArrayList<Double> cumLengths;
    double length;

    public PolyLine(PathIterator pi) {
        double[] coords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Point2D.Double lastPt = new Point2D.Double();
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    lastPt = new Point2D.Double(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    Point2D.Double newPt = new Point2D.Double(coords[0], coords[1]);
                    this.segments.add(new Line2D.Double(lastPt, newPt));
                    lastPt = newPt;
                }
            }
            pi.next();
        }
        this.calcCumLengths();
    }

    public void calcCumLengths() {
        this.length = 0.0;
        this.cumLengths = new ArrayList(this.segments.size());
        for (int i = 0; i < this.segments.size(); ++i) {
            this.cumLengths.add(new Double(this.length));
            this.length += PolyLine.segmentLength(this.segments.get(i));
        }
    }

    public double cumLengthAt(Point2D pt) {
        int segi = this.nearestSegmentIdx(pt);
        Point2D segPt = this.segments.get(segi).getP1();
        double dx = pt.getX() - segPt.getX();
        double dy = pt.getY() - segPt.getY();
        return this.cumLengths.get(segi) + Math.sqrt(dx * dx + dy * dy);
    }

    public double getLength() {
        return this.length;
    }

    public double getLengthAtSegmentIdx(int idx) {
        return this.cumLengths.get(idx);
    }

    public Point2D nearestPoint(Point2D pt) {
        return PolyLine.nearestPointOnSegment(pt, this.nearestSegment(pt));
    }

    public Line2D nearestSegment(Point2D pt) {
        return this.segments.get(this.nearestSegmentIdx(pt));
    }

    public int nearestSegmentIdx(Point2D pt) {
        double shortestDist = Double.POSITIVE_INFINITY;
        int nearestSegIdx = 0;
        int i = 0;
        for (i = 0; i < this.segments.size(); ++i) {
            double dist = this.segments.get(i).ptSegDist(pt);
            if (!(dist < shortestDist)) continue;
            shortestDist = dist;
            nearestSegIdx = i;
        }
        return nearestSegIdx;
    }

    public static Point2D nearestPointOnSegment(Point2D pt, Line2D seg) {
        Point2D p1 = seg.getP1();
        Point2D p2 = seg.getP2();
        Vector2D segv = new Vector2D(p1, p2);
        double len = segv.length();
        segv.normalize();
        Vector2D ptv = new Vector2D(p1, pt);
        double t = Vector2D.dot_product(ptv, segv) / len;
        Point2D closestPt = p1;
        if (t > 1.0) {
            closestPt = p2;
        } else if (t > 0.0) {
            closestPt = new Point2D.Double((1.0 - t) * p1.getX() + t * p2.getX(), (1.0 - t) * p1.getY() + t * p2.getY());
        }
        return closestPt;
    }

    public static Point2D SegmentSegmentIntersection(Line2D l1, Line2D l2) {
        double x1 = l1.getX1();
        double y1 = l1.getY1();
        double x2 = l1.getX1();
        double y2 = l1.getY2();
        double xx1 = l2.getX1();
        double yy1 = l2.getY1();
        double xx2 = l2.getX2();
        double yy2 = l2.getY2();
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            return null;
        }
        double x = (b0 * c1 - b1 * c0) / (a0 * b1 - a1 * b0);
        double y = (a0 * c1 - a1 * c0) / (a1 * b0 - a0 * b1);
        return new Point2D.Double(x, y);
    }

    public boolean rayCircleIntersections(Line2D seg, Point2D cc, double r, Point2D int1, Point2D int2) {
        Point2D p1 = seg.getP1();
        Point2D p2 = seg.getP2();
        Point2D.Double dp = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        double a = dp.getX() * dp.getX() + dp.getY() * dp.getY();
        double b = 2.0 * (dp.getX() * (p1.getX() - cc.getX()) + dp.getY() * (p1.getY() - cc.getY()));
        double c = cc.getX() * cc.getX() + cc.getY() * cc.getY();
        c += p1.getX() * p1.getX() + p1.getY() * p1.getY();
        c -= 2.0 * (cc.getX() * p1.getX() + cc.getY() * p1.getY());
        double bb4ac = b * b - 4.0 * a * (c -= r * r);
        if (Math.abs(a) < 1.0E-5 || bb4ac < 0.0) {
            int1.setLocation(Double.NaN, Double.NaN);
            int2.setLocation(Double.NaN, Double.NaN);
            return false;
        }
        double mu1 = (-b + Math.sqrt(bb4ac)) / (2.0 * a);
        double mu2 = (-b - Math.sqrt(bb4ac)) / (2.0 * a);
        Vector2D v1 = new Vector2D(p1, p2);
        Vector2D v2 = new Vector2D(p1, p2);
        v1.multiply(mu1);
        v2.multiply(mu2);
        int1.setLocation(p1.getX() + v1.x, p1.getY() + v1.y);
        int2.setLocation(p2.getX() + v2.x, p2.getY() + v1.y);
        return true;
    }

    public int intersectsCircleOnStartPoint(double r, double altR, Point2D intPt) {
        Point2D center = this.segments.get(0).getP1();
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        for (int i = 0; i < this.segments.size(); ++i) {
            if (center.distance(this.segments.get(i).getP2()) < r || !this.rayCircleIntersections(this.segments.get(i), center, r, pt1, pt2)) continue;
            intPt.setLocation(pt1);
            return i;
        }
        Double shortR = altR * center.distance(this.segments.get(this.segments.size() - 1).getP2());
        for (int i = 0; i < this.segments.size(); ++i) {
            if (center.distance(this.segments.get(i).getP2()) < shortR || !this.rayCircleIntersections(this.segments.get(i), center, shortR, pt1, pt2)) continue;
            intPt.setLocation(pt1);
            return i;
        }
        return -1;
    }

    public static final double segmentLength(Line2D seg) {
        double dx = seg.getX2() - seg.getX1();
        double dy = seg.getY2() - seg.getY1();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Point2D firstPoint() {
        return this.segments.get(0).getP1();
    }

    public Point2D lastPoint() {
        return this.segments.get(this.segments.size() - 1).getP2();
    }
}

