/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourcePoolReference;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.ConnectorService;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceConstants;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

public class ConnectorsUtil {
    private static Logger _logger = LogDomains.getLogger(ConnectorsUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    private static Collection<String> validSystemRARs = new HashSet<String>();
    private static Collection<String> validNonJdbcSystemRARs = new HashSet<String>();

    public static boolean belongsToSystemRA(String raName) {
        boolean result = false;
        for (String systemRarName : ConnectorsUtil.getSystemRARs()) {
            if (!systemRarName.equals(raName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean getPingDuringPoolCreation(PoolInfo poolInfo, Resources allResources) {
        ResourcePool pool = ConnectorsUtil.getConnectionPoolConfig(poolInfo, allResources);
        return Boolean.parseBoolean(pool.getPing());
    }

    public static boolean belongsToJdbcRA(String raName) {
        boolean result = false;
        for (String systemRarName : ConnectorConstants.jdbcSystemRarNames) {
            if (!systemRarName.equals(raName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    private static ConfigBeansUtilities getConfigBeansUtilities() {
        ServiceLocator locator = Globals.getDefaultHabitat();
        if (locator == null) {
            return null;
        }
        return (ConfigBeansUtilities)locator.getService(ConfigBeansUtilities.class, new Annotation[0]);
    }

    private static String internalGetLocation(String moduleName) {
        ConfigBeansUtilities cbu = ConnectorsUtil.getConfigBeansUtilities();
        if (cbu == null) {
            return null;
        }
        return cbu.getLocation(moduleName);
    }

    public static String getLocation(String moduleName) throws ConnectorRuntimeException {
        Object location = null;
        if (ConnectorsUtil.belongsToSystemRA(moduleName)) {
            location = ConnectorsUtil.getSystemModuleLocation(moduleName);
        } else {
            location = ConnectorsUtil.internalGetLocation(moduleName);
            if (location == null) {
                String rarName = ConnectorsUtil.getRarNameFromApplication(moduleName);
                String appName = ConnectorsUtil.getApplicationNameOfEmbeddedRar(moduleName);
                location = ConnectorsUtil.internalGetLocation(appName);
                if (location != null) {
                    location = (String)location + File.separator + rarName + "_rar";
                } else {
                    throw new ConnectorRuntimeException("Unable to find location for module : " + moduleName);
                }
            }
        }
        return location;
    }

    public static String getPMJndiName(String jndiName) {
        return jndiName + "__pm";
    }

    public static String getValidSuffix(String name) {
        if (name != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!name.endsWith(validSuffix)) continue;
                return validSuffix;
            }
        }
        return null;
    }

    public static boolean isValidJndiSuffix(String suffix) {
        if (suffix != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!validSuffix.equals(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String deriveJndiName(String name, Hashtable env) {
        String suffix = (String)env.get("com.sun.enterprise.connectors.jndisuffix");
        if (ConnectorsUtil.isValidJndiSuffix(suffix)) {
            return name + suffix;
        }
        return name;
    }

    public static ResourcePool getConnectionPoolConfig(PoolInfo poolInfo, Resources allResources) {
        ResourcePool pool = null;
        for (Resource configuredResource : allResources.getResources()) {
            ResourcePool resourcePool;
            if (!(configuredResource instanceof ResourcePool) || !(resourcePool = (ResourcePool)configuredResource).getName().equals(poolInfo.getName())) continue;
            pool = resourcePool;
            break;
        }
        return pool;
    }

    public static Collection<Resource> getAllResources(Collection<String> poolNames, Resources allResources) {
        ArrayList<Resource> connectorResources = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            ConnectorResource connectorResource;
            if (!(resource instanceof ConnectorResource) || !poolNames.contains((connectorResource = (ConnectorResource)resource).getPoolName())) continue;
            connectorResources.add(connectorResource);
        }
        return connectorResources;
    }

    public static Collection<String> getAllPoolNames(Collection<ConnectorConnectionPool> connectionPools) {
        HashSet<String> poolNames = new HashSet<String>();
        for (ConnectorConnectionPool pool : connectionPools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }

    public static Collection<WorkSecurityMap> getAllWorkSecurityMaps(Resources resources, String moduleName) {
        ArrayList<WorkSecurityMap> workSecurityMaps = new ArrayList<WorkSecurityMap>();
        for (WorkSecurityMap resource : resources.getResources(WorkSecurityMap.class)) {
            if (!resource.getResourceAdapterName().equals(moduleName)) continue;
            workSecurityMaps.add(resource);
        }
        return workSecurityMaps;
    }

    public static Collection<ConnectorConnectionPool> getAllPoolsOfModule(String moduleName, Resources allResources) {
        ArrayList<ConnectorConnectionPool> connectorConnectionPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool connectorConnectionPool;
            if (!(resource instanceof ConnectorConnectionPool) || !(connectorConnectionPool = (ConnectorConnectionPool)resource).getResourceAdapterName().equals(moduleName)) continue;
            connectorConnectionPools.add(connectorConnectionPool);
        }
        return connectorConnectionPools;
    }

    public static Collection<Resource> getAllSystemRAResourcesAndPools(Resources allResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList<Resource> pools = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            String raName;
            if (resource instanceof ConnectorConnectionPool) {
                raName = ((ConnectorConnectionPool)resource).getResourceAdapterName();
                if (!ConnectorsUtil.belongsToSystemRA(raName)) continue;
                pools.add(resource);
                continue;
            }
            if (resource instanceof ConnectorResource) {
                String poolName = ((ConnectorResource)resource).getPoolName();
                String raName2 = ConnectorsUtil.getResourceAdapterNameOfPool(poolName, allResources);
                if (!ConnectorsUtil.belongsToSystemRA(raName2)) continue;
                resources.add(resource);
                continue;
            }
            if (!(resource instanceof AdminObjectResource) || !ConnectorsUtil.belongsToSystemRA(raName = ((AdminObjectResource)resource).getResAdapter())) continue;
            resources.add(resource);
        }
        resources.addAll(pools);
        return resources;
    }

    public static String getResourceAdapterNameOfPool(String poolName, Resources allResources) {
        String raName = null;
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool ccp;
            String name;
            if (!(resource instanceof ConnectorConnectionPool) || !(name = (ccp = (ConnectorConnectionPool)resource).getName()).equalsIgnoreCase(poolName)) continue;
            raName = ccp.getResourceAdapterName();
            break;
        }
        return raName;
    }

    public static ResourceAdapterConfig getRAConfig(String raName, Resources allResources) {
        Collection raConfigs = allResources.getResources(ResourceAdapterConfig.class);
        for (ResourceAdapterConfig rac : raConfigs) {
            if (!rac.getResourceAdapterName().equals(raName)) continue;
            return rac;
        }
        return null;
    }

    public static List<WorkSecurityMap> getWorkSecurityMaps(String raName, Resources allResources) {
        List resourcesList = allResources.getResources();
        ArrayList<WorkSecurityMap> workSecurityMaps = new ArrayList<WorkSecurityMap>();
        for (Resource resource : resourcesList) {
            WorkSecurityMap wsm;
            if (!(resource instanceof WorkSecurityMap) || !(wsm = (WorkSecurityMap)resource).getResourceAdapterName().equals(raName)) continue;
            workSecurityMaps.add(wsm);
        }
        return workSecurityMaps;
    }

    public static boolean isDynamicReconfigurationEnabled(ResourcePool pool) {
        PropertyBag properties;
        Property property;
        boolean enabled = false;
        if (pool instanceof PropertyBag && (property = (properties = (PropertyBag)pool).getProperty("dynamic-reconfiguration-wait-timeout-in-seconds")) != null) {
            try {
                if (Long.parseLong(property.getValue()) > 0L) {
                    enabled = true;
                }
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "invalid.dynamic-reconfig.value", property.getValue());
            }
        }
        return enabled;
    }

    public static Set getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }

    public static boolean isJMSRA(String moduleName) {
        return "jmsra".equals(moduleName);
    }

    public static boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled);
    }

    public static long getShutdownTimeout(ConnectorService connectorService) {
        int shutdownTimeout;
        try {
            if (connectorService == null) {
                shutdownTimeout = 30;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " through default");
                }
            } else {
                shutdownTimeout = Integer.parseInt(connectorService.getShutdownTimeoutInSeconds());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " from domain.xml");
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "error_reading_connectorservice_elt", e);
            shutdownTimeout = 30;
        }
        return (long)shutdownTimeout * 1000L;
    }

    public static Map<String, String> getBuiltInCustomResources() {
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        resourcesMap.put("java.lang.Integer", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Long", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Double", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Float", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Character", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Short", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Byte", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Boolean", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.String", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.net.URL", "org.glassfish.resources.custom.factory.URLObjectFactory");
        resourcesMap.put("java.util.Properties", "org.glassfish.resources.custom.factory.PropertiesFactory");
        return resourcesMap;
    }

    public static String getTransactionIsolationInt(int tranIsolation) {
        if (tranIsolation == 1) {
            return "read-uncommited";
        }
        if (tranIsolation == 2) {
            return "read-committed";
        }
        if (tranIsolation == 4) {
            return "repeatable-read";
        }
        if (tranIsolation == 8) {
            return "serializable";
        }
        throw new RuntimeException("Invalid transaction isolation; the transaction isolation level can be empty or any of the following: read-uncommitted, read-committed, repeatable-read, serializable");
    }

    public static String deriveResourceName(String compId, String name, JavaEEResourceType resType) {
        String derivedName = name;
        return ConnectorsUtil.getReservePrefixedJNDINameForResource(compId, derivedName, resType);
    }

    public static String getReservePrefixedJNDINameForResource(String compId, String resourceName, JavaEEResourceType resType) {
        String prefix = null;
        String prefixPart1 = null;
        String prefixPart2 = null;
        if (resType != null) {
            switch (resType) {
                case DSD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__datasource_definition/";
                    break;
                }
                case MSD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__mailsession_definition/";
                    break;
                }
                case CFD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__connection_factory_definition/";
                    break;
                }
                case DSDPOOL: {
                    prefixPart1 = "__SYSTEM/pools/";
                    prefixPart2 = "__datasource_definition/";
                    break;
                }
                case CFDPOOL: {
                    prefixPart1 = "__SYSTEM/pools/";
                    prefixPart2 = "__connection_factory_definition/";
                    break;
                }
                case JMSCFDD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__jms_connection_factory_definition/";
                    break;
                }
                case JMSCFDDPOOL: {
                    prefixPart1 = "__SYSTEM/pools/";
                    prefixPart2 = "__jms_connection_factory_definition/";
                    break;
                }
                case JMSDD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__jms_destination_definition/";
                    break;
                }
                case AODD: {
                    prefixPart1 = "__SYSTEM/resource/";
                    prefixPart2 = "__administered_object_definition/";
                }
            }
        }
        prefix = compId == null || compId.equals("") ? prefixPart1 + prefixPart2 : prefixPart1 + prefixPart2 + compId + "/";
        return ConnectorsUtil.getReservePrefixedJNDIName(prefix, resourceName);
    }

    public static Map<String, String> convertPropertiesToMap(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        return new TreeMap<Object, Object>(properties);
    }

    private static String getReservePrefixedJNDIName(String prefix, String resourceName) {
        return prefix + resourceName;
    }

    public static String getEmbeddedRarModuleName(String applicationName, String moduleName) {
        String embeddedRarName = ((String)moduleName).substring(0, ((String)moduleName).indexOf("_rar"));
        moduleName = applicationName + "#" + embeddedRarName;
        return moduleName;
    }

    public static String getApplicationNameOfEmbeddedRar(String embeddedRarName) {
        int index = embeddedRarName.indexOf("#");
        String applicationName = embeddedRarName;
        if (index != -1) {
            applicationName = embeddedRarName.substring(0, index);
        }
        return applicationName;
    }

    public static String getRarNameFromApplication(String appName) {
        int index = appName.indexOf("#");
        String rarName = appName;
        if (index != -1 && appName.length() > index + 1) {
            rarName = appName.substring(index + 1);
        }
        return rarName;
    }

    public static boolean isEmbedded(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        return archive != null && archive.getParentArchive() != null;
    }

    public static String getApplicationName(DeploymentContext context) {
        String applicationName = null;
        ReadableArchive parentArchive = context.getSource().getParentArchive();
        applicationName = parentArchive != null ? parentArchive.getName() : context.getSource().getName();
        return applicationName;
    }

    public static List<URI> getInstalledLibrariesFromManifest(String moduleDirectory, ServerEnvironment env) throws ConnectorRuntimeException {
        ArrayList<URI> libURIs = new ArrayList<URI>();
        if (moduleDirectory != null) {
            try {
                File module = new File(moduleDirectory);
                if (module.exists()) {
                    URL[] extensionListLibraries;
                    FileArchive fileArchive = new FileArchive();
                    fileArchive.open(module.toURI());
                    Set extensionList = InstalledLibrariesResolver.getInstalledLibraries((ReadableArchive)fileArchive);
                    for (URL url : extensionListLibraries = ASClassLoaderUtil.getLibrariesAsURLs((Set)extensionList, (ServerEnvironment)env)) {
                        libURIs.add(url.toURI());
                        if (!_logger.isLoggable(Level.FINEST)) continue;
                        _logger.log(Level.FINEST, "adding URL [ " + url + " ] to installedLibraries");
                    }
                }
            }
            catch (IOException ioe) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(ioe.getMessage());
                cre.initCause(ioe);
                throw cre;
            }
            catch (URISyntaxException e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                cre.initCause(e);
                throw cre;
            }
        }
        return libURIs;
    }

    public static String getReservePrefixedJNDINameForDescriptor(String moduleName) {
        return ConnectorsUtil.getReservePrefixedJNDIName("__SYSTEM/descriptors/", moduleName);
    }

    public static boolean isStandAloneRA(String moduleName) {
        ConfigBeansUtilities cbu = ConnectorsUtil.getConfigBeansUtilities();
        ApplicationName an = null;
        if (cbu != null) {
            an = cbu.getModule(moduleName);
        }
        return an != null;
    }

    public static Collection<String> getSystemRARs() {
        return validSystemRARs;
    }

    private static void initializeSystemRars() {
        for (String rarName : ConnectorConstants.systemRarNames) {
            if (!ConnectorsUtil.systemRarExists(ConnectorsUtil.getSystemModuleLocation(rarName))) continue;
            validSystemRARs.add(rarName);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "valid system RARs for this runtime are : " + validSystemRARs);
        }
    }

    public static Collection<String> getNonJdbcSystemRars() {
        return validNonJdbcSystemRARs;
    }

    private static void initializeNonJdbcSystemRars() {
        Collection<String> systemRars = ConnectorsUtil.getSystemRARs();
        for (String rarName : systemRars) {
            if (ConnectorConstants.jdbcSystemRarNames.contains(rarName)) continue;
            validNonJdbcSystemRARs.add(rarName);
        }
    }

    public static boolean systemRarExists(String location) {
        boolean result;
        block2: {
            result = false;
            try {
                File file = new File(location);
                result = file.exists();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINEST)) break block2;
                _logger.log(Level.FINEST, "Exception occurred while checking System RAR location : [" + location + "]", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractRar(String fileName, String rarName, String destDir) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(rarName);
        if (is != null) {
            FileArchive fa = new FileArchive();
            OutputStream os = null;
            try {
                os = fa.putNextEntry(fileName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)0L);
            }
            catch (IOException e) {
                Object[] args = new Object[]{rarName, e};
                _logger.log(Level.WARNING, "error.extracting.archive", args);
                boolean bl = false;
                return bl;
            }
            finally {
                block24: {
                    block23: {
                        try {
                            if (os != null) {
                                fa.closeEntry();
                            }
                        }
                        catch (IOException ioe) {
                            if (!_logger.isLoggable(Level.FINEST)) break block23;
                            _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe);
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        if (!_logger.isLoggable(Level.FINEST)) break block24;
                        _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe);
                    }
                }
            }
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    ConnectorsUtil.extractJar(file, destDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            _logger.log(Level.INFO, "could not find RAR [ " + rarName + " ] location [ " + fileName + " ] after extraction");
            return false;
        }
        _logger.log(Level.INFO, "could not find RAR [ " + rarName + " ] in the archive, skipping .rar extraction");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractJar(File jarFile, String destDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enum1 = jar.entries();
        try {
            while (enum1.hasMoreElements()) {
                InputStream is;
                JarEntry file;
                block22: {
                    file = enum1.nextElement();
                    File f = new File(destDir + File.separator + file.getName());
                    if (file.isDirectory() && f.mkdir()) continue;
                    is = null;
                    FileOutputStream fos = null;
                    try {
                        is = jar.getInputStream(file);
                        fos = new FileOutputStream(f);
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                    catch (Throwable throwable) {
                        block21: {
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (Exception e) {
                                if (!_logger.isLoggable(Level.FINEST)) break block21;
                                _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e);
                            }
                        }
                        try {
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            if (!_logger.isLoggable(Level.FINEST)) throw throwable;
                            _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e);
                        }
                        throw throwable;
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINEST)) break block22;
                        _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e);
                    }
                }
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e);
                }
            }
            return;
        }
        finally {
            block23: {
                try {
                    jar.close();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINEST)) break block23;
                    _logger.log(Level.FINEST, "exception while closing archive [ " + jar.getName() + " ]", e);
                }
            }
        }
    }

    public static PoolInfo getPoolInfo(ResourcePool resource) {
        return ResourceUtil.getPoolInfo((ResourcePool)resource);
    }

    public static ResourceInfo getResourceInfo(BindableResource resource) {
        return ResourceUtil.getResourceInfo((BindableResource)resource);
    }

    public static String getApplicationName(Resource resource) {
        String applicationName = null;
        if (resource.getParent() != null && resource.getParent().getParent() instanceof Application) {
            Application application = (Application)resource.getParent().getParent();
            applicationName = application.getName();
        }
        return applicationName;
    }

    public static String getApplicationName(PoolInfo poolInfo) {
        return poolInfo.getApplicationName();
    }

    public static boolean isApplicationScopedResource(GenericResourceInfo resourceInfo) {
        return ResourceUtil.isApplicationScopedResource((GenericResourceInfo)resourceInfo);
    }

    public static boolean isModuleScopedResource(GenericResourceInfo resourceInfo) {
        return ResourceUtil.isModuleScopedResource((GenericResourceInfo)resourceInfo);
    }

    public static String escapeResourceNameForMonitoring(String name) {
        return name.replaceAll("/", "___SLASH___");
    }

    public static String getPoolMonitoringSubTreeRoot(PoolInfo poolInfo, boolean escapeSlashes) {
        String resourcesPrefix = "resources/";
        String suffix = poolInfo.getName();
        if (escapeSlashes) {
            suffix = ConnectorsUtil.escapeResourceNameForMonitoring(suffix);
        }
        String subTreeRoot = resourcesPrefix + suffix;
        if (ConnectorsUtil.isModuleScopedResource((GenericResourceInfo)poolInfo)) {
            subTreeRoot = "applications/" + poolInfo.getApplicationName() + "/" + poolInfo.getModuleName() + "/" + resourcesPrefix + "/" + suffix;
        } else if (ConnectorsUtil.isApplicationScopedResource((GenericResourceInfo)poolInfo)) {
            subTreeRoot = "applications/" + poolInfo.getApplicationName() + "/" + resourcesPrefix + "/" + suffix;
        }
        return subTreeRoot;
    }

    public static String getActualModuleName(String moduleName) {
        return ResourceUtil.getActualModuleName((String)moduleName);
    }

    public static String getModuleName(EjbDescriptor descriptor) {
        String prefix;
        String moduleName;
        String appName = descriptor.getApplication().getAppName();
        String actualModuleName = moduleName = descriptor.getEjbBundleDescriptor().getModuleID();
        if (moduleName != null && moduleName.startsWith(prefix = appName + "#")) {
            actualModuleName = moduleName.substring(prefix.length());
        }
        return actualModuleName;
    }

    public static Collection<BindableResource> getResourcesOfPool(Resources resources, String connectionPoolName) {
        HashSet<BindableResource> resourcesReferringPool = new HashSet<BindableResource>();
        ResourcePool pool = (ResourcePool)ConnectorsUtil.getResourceByName(resources, ResourcePool.class, connectionPoolName);
        if (pool != null) {
            Collection bindableResources = resources.getResources(BindableResource.class);
            for (BindableResource resource : bindableResources) {
                if (!ResourcePoolReference.class.isAssignableFrom(resource.getClass()) || !((ResourcePoolReference)resource).getPoolName().equals(connectionPoolName)) continue;
                resourcesReferringPool.add(resource);
            }
        }
        return resourcesReferringPool;
    }

    public static <T> Resource getResourceByName(Resources resources, Class<T> type, String name) {
        return resources.getResourceByName(type, name);
    }

    public static ResourceConstants.TriState isEmbeddedRarResource(Resource configBeanResource, Collection<Resource> configBeanResources) {
        WorkSecurityMap wsm;
        ResourceConstants.TriState result = ResourceConstants.TriState.FALSE;
        if (configBeanResource instanceof ConnectorResource) {
            String poolName = ((ConnectorResource)configBeanResource).getPoolName();
            ConnectorConnectionPool pool = ConnectorsUtil.getPool(configBeanResources, poolName);
            if (pool != null) {
                if (pool.getResourceAdapterName().contains("#")) {
                    result = ResourceConstants.TriState.TRUE;
                }
            } else {
                result = ResourceConstants.TriState.UNKNOWN;
            }
        } else if (configBeanResource instanceof AdminObjectResource) {
            AdminObjectResource aor = (AdminObjectResource)configBeanResource;
            if (aor.getResAdapter().contains("#")) {
                result = ResourceConstants.TriState.TRUE;
            }
        } else if (configBeanResource instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)configBeanResource;
            if (ccp.getResourceAdapterName().contains("#")) {
                result = ResourceConstants.TriState.TRUE;
            }
        } else if (configBeanResource instanceof WorkSecurityMap && (wsm = (WorkSecurityMap)configBeanResource).getResourceAdapterName().contains("#")) {
            result = ResourceConstants.TriState.TRUE;
        }
        return result;
    }

    public static ConnectorConnectionPool getPool(Collection<Resource> configBeanResources, String poolName) {
        ConnectorConnectionPool result = null;
        for (Resource res : configBeanResources) {
            if (!(res instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)res).getName().equals(poolName)) continue;
            result = (ConnectorConnectionPool)res;
            break;
        }
        return result;
    }

    public static boolean isRARResource(Resource resource) {
        return resource instanceof ConnectorResource || resource instanceof AdminObjectResource || resource instanceof ConnectorConnectionPool || resource instanceof ResourceAdapterConfig || resource instanceof WorkSecurityMap;
    }

    public static String getRarNameOfResource(Resource resource, Resources resources) {
        String rarName = null;
        if (ConnectorsUtil.isRARResource(resource)) {
            if (resource instanceof ConnectorResource) {
                String poolName = ((ConnectorResource)resource).getPoolName();
                for (Resource res : resources.getResources()) {
                    ConnectorConnectionPool ccp;
                    if (!(res instanceof ConnectorConnectionPool) || !(ccp = (ConnectorConnectionPool)res).getName().equals(poolName)) continue;
                    return ccp.getResourceAdapterName();
                }
            } else {
                if (resource instanceof ConnectorConnectionPool) {
                    ConnectorConnectionPool ccp = (ConnectorConnectionPool)resource;
                    return ccp.getResourceAdapterName();
                }
                if (resource instanceof AdminObjectResource) {
                    AdminObjectResource aor = (AdminObjectResource)resource;
                    return aor.getResAdapter();
                }
                if (resource instanceof ResourceAdapterConfig) {
                    ResourceAdapterConfig rac = (ResourceAdapterConfig)resource;
                    return rac.getResourceAdapterName();
                }
                if (resource instanceof WorkSecurityMap) {
                    WorkSecurityMap wsm = (WorkSecurityMap)resource;
                    return wsm.getResourceAdapterName();
                }
            }
        }
        return rarName;
    }

    static {
        ConnectorsUtil.initializeSystemRars();
        ConnectorsUtil.initializeNonJdbcSystemRars();
    }
}

