/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.containerelementlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ContainerElementTypeConstraintsForGetterXmlMappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementTypeConstraintsForGetterXmlMappingTest.webArchiveBuilder().withTestClass(ContainerElementTypeConstraintsForGetterXmlMappingTest.class)).withResource("getter-canDeclareContainerElementTypeConstraints-mapping.xml")).withResource("getter-canDeclareNestedContainerElementTypeConstraints-mapping.xml")).withResource("getter-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml")).withResource("getter-canDeclareContainerElementCascades-mapping.xml")).withResource("getter-declaringContainerElementTypeConstraintOnNonGenericFieldCausesException-mapping.xml")).withResource("getter-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException-mapping.xml")).withResource("getter-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException-mapping.xml")).withResource("getter-omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException-mapping.xml")).withResource("getter-configuringSameContainerElementTwiceCausesException-mapping.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="d"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareContainerElementTypeConstraintsForGetterWithXmlMapping() {
        Validator validator = this.getValidator("getter-canDeclareContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 0 and 5"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareNestedContainerElementTypeConstraintsForGetterWithXmlMapping() {
        Validator validator = this.getValidator("getter-canDeclareNestedContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareDeeplyNestedContainerElementTypeConstraintsForGetterWithXmlMapping() {
        Validator validator = this.getValidator("getter-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="h")})
    public void canDeclareContainerElementCascadesForGetterWithXmlMapping() {
        Validator validator = this.getValidator("getter-canDeclareContainerElementCascades-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="j")
    public void declaringContainerElementTypeConstraintOnNonGenericFieldCausesException() {
        this.getValidator("getter-declaringContainerElementTypeConstraintOnNonGenericFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException() {
        this.getValidator("getter-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException() {
        this.getValidator("getter-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="l")
    public void omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException() {
        this.getValidator("getter-omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="m")
    public void configuringSameContainerElementTwiceCausesException() {
        this.getValidator("getter-configuringSameContainerElementTwiceCausesException-mapping.xml");
    }

    private Validator getValidator(String mappingFile) {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile));
        return config.buildValidatorFactory().getValidator();
    }

    public static class Fish {
        public String getName() {
            return null;
        }
    }

    public static class FishTank {
        public Optional<String> getModel() {
            return Optional.of("Too long");
        }

        public Optional<Fish> getBoss() {
            return Optional.of(new Fish());
        }

        public Map<String, Integer> getFishCountByType() {
            HashMap<String, Integer> fishCount = new HashMap<String, Integer>();
            fishCount.put("A", -1);
            fishCount.put("BB", -2);
            return fishCount;
        }

        public Map<String, List<Fish>> getFishOfTheMonth() {
            HashMap<String, List<Fish>> fishOfTheMonth = new HashMap<String, List<Fish>>();
            List<Fish> january = Arrays.asList(null, new Fish());
            fishOfTheMonth.put("january", january);
            return fishOfTheMonth;
        }

        public List<Map<String, Set<String>>> getTagsOfFishOfTheMonth() {
            Set<String> bobsTags = CollectionHelper.asSet(new String[]{null});
            HashMap<String, Set<String>> january = new HashMap<String, Set<String>>();
            january.put("bob", bobsTags);
            ArrayList<Map<String, Set<String>>> tagsOfFishOfTheMonth = new ArrayList<Map<String, Set<String>>>();
            tagsOfFishOfTheMonth.add(january);
            return tagsOfFishOfTheMonth;
        }

        public int getSize() {
            return 0;
        }
    }
}

