/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.ChineseDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import org.eclipse.edt.javart.util.JavartDateFormat;

public class JavartChineseDateFormat
extends ChineseDateFormat
implements JavartDateFormat {
    private static final long serialVersionUID = 10L;
    private int microsecond;
    private int century;

    public JavartChineseDateFormat(String pattern, ULocale locale) {
        super(pattern, locale);
    }

    @Override
    public int getCentury() {
        return this.century;
    }

    @Override
    public void setCentury(int century) {
        this.century = century;
    }

    @Override
    public int getMicrosecond() {
        return this.microsecond;
    }

    @Override
    public void setMicrosecond(int microsecond) {
        this.microsecond = microsecond;
    }

    @Override
    public Date parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(text, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("ParseException: \"" + text + "\"", pos.getErrorIndex());
        }
        if (pos.getIndex() != text.length()) {
            throw new ParseException("ParseException: \"" + text + "\"", pos.getIndex());
        }
        return result;
    }

    protected int subParse(String text, int start, char ch, int count, boolean obeyCount, boolean allowNegative, boolean[] ambiguousYear, Calendar cal) {
        if (ch != 'C' && ch != 'S' && ch != 'f') {
            return super.subParse(text, start, ch, count, obeyCount, allowNegative, ambiguousYear, cal);
        }
        start = Utility.skipWhitespace((String)text, (int)start);
        ParsePosition pos = new ParsePosition(start);
        Number number = null;
        if (obeyCount) {
            if (start + count > text.length()) {
                return -start;
            }
            number = this.numberFormat.parse(text.substring(0, start + count), pos);
        } else {
            number = this.numberFormat.parse(text, pos);
        }
        if (number == null) {
            return -start;
        }
        int value = number.intValue();
        if (ch == 'C') {
            this.setCentury(value);
        } else {
            int i = pos.getIndex() - start;
            if (i < 6) {
                value *= 10;
                ++i;
                while (i < 6) {
                    value *= 10;
                    ++i;
                }
            } else if (i > 6) {
                int a = 10;
                --i;
                while (i > 6) {
                    a *= 10;
                    --i;
                }
                value = (value + (a >> 1)) / a;
            }
            this.setMicrosecond(value);
        }
        return pos.getIndex();
    }

    protected void subFormat(StringBuffer buf, char ch, int count, int beginOffset, FieldPosition pos, Calendar cal) {
        switch (ch) {
            case 'M': {
                super.subFormat(buf, ch, Math.min(count, 4), beginOffset, pos, cal);
                break;
            }
            case 'C': {
                buf.append(this.zeroPaddingNumber(this.getCentury(), count, Integer.MAX_VALUE));
                break;
            }
            case 'S': 
            case 'f': {
                int value = this.getMicrosecond();
                switch (count) {
                    case 1: {
                        value = (value + 50000) / 100000;
                        break;
                    }
                    case 2: {
                        value = (value + 5000) / 10000;
                        break;
                    }
                    case 3: {
                        value = (value + 500) / 1000;
                        break;
                    }
                    case 4: {
                        value = (value + 50) / 100;
                        break;
                    }
                    case 5: {
                        value = (value + 5) / 10;
                    }
                }
                FieldPosition p = new FieldPosition(-1);
                this.numberFormat.setMinimumIntegerDigits(Math.min(6, count));
                this.numberFormat.setMaximumIntegerDigits(Integer.MAX_VALUE);
                this.numberFormat.format((long)value, buf, p);
                if (count <= 6) break;
                this.numberFormat.setMinimumIntegerDigits(count - 6);
                this.numberFormat.format(0L, buf, p);
                break;
            }
            default: {
                super.subFormat(buf, ch, count, beginOffset, pos, cal);
            }
        }
    }
}

