/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.edt.javart.resources.JavartProperties;

public class LocalizedText
implements Serializable {
    private static final long serialVersionUID = 10L;
    private JavartProperties properties;
    public static final String NLS_ENU = "ENU";
    public static final String NLS_DEU = "DEU";
    public static final String NLS_DES = "DES";
    public static final String NLS_ESP = "ESP";
    public static final String NLS_FRA = "FRA";
    public static final String NLS_ITA = "ITA";
    public static final String NLS_PTB = "PTB";
    public static final String NLS_KOR = "KOR";
    public static final String NLS_JPN = "JPN";
    public static final String NLS_CHS = "CHS";
    public static final String NLS_CHT = "CHT";
    public static final String NLS_RUS = "RUS";
    public static final String NLS_PLK = "PLK";
    public static final String NLS_CZE = "CZE";
    public static final String NLS_HUN = "HUN";
    public static final String NLS_ARA = "ARA";
    public static final int CHS = 1;
    public static final int CHT = 2;
    public static final int DES = 3;
    public static final int DEU = 4;
    public static final int ENU = 5;
    public static final int ESP = 6;
    public static final int FRA = 7;
    public static final int ITA = 8;
    public static final int JPN = 9;
    public static final int KOR = 10;
    public static final int PTB = 11;
    public static final int RUS = 12;
    public static final int HUN = 13;
    public static final int CZE = 14;
    public static final int PLK = 15;
    public static final int ARA = 16;
    private static final int CURRENCY_LOCATION_UNKNOWN = -1;
    public static final int CURRENCY_LOCATION_NONE = 0;
    public static final int CURRENCY_LOCATION_FRONT = 1;
    public static final int CURRENCY_LOCATION_BACK = 2;
    private String nlsCode;
    private int languageID;
    private Locale locale;
    private String inputNlsCode;
    private Locale inputLocale;
    private DecimalFormatSymbols decimalFormatSymbols = null;
    private char decimalSymbol = (char)65535;
    private char monetaryDecimalSeparator = (char)65535;
    private String currencySymbol = null;
    private int currencyLocation = -1;
    private char separatorSymbol = (char)65535;
    private String shortGregorianDateMask = null;
    private String longGregorianDateMask = null;
    private String shortJulianDateMask = null;
    private String longJulianDateMask = null;
    private DateFormat dateFormatter;
    private boolean decimalSymbolSetInProperties;
    private transient ResourceBundle userMessages;
    private transient ResourceBundle eglMessages;
    private static HashMap bundleCache = new HashMap(32);

    public LocalizedText(JavartProperties properties) {
        this.properties = properties;
        this.inputNlsCode = properties.get("egl.nls.code");
        this.inputLocale = null;
        if (this.inputNlsCode == null) {
            this.locale = Locale.getDefault();
            this.setNlsCodeFromLocale();
        } else {
            this.nlsCode = this.inputNlsCode.equals(NLS_ENU) || this.inputNlsCode.equals(NLS_DEU) || this.inputNlsCode.equals(NLS_DES) || this.inputNlsCode.equals(NLS_ESP) || this.inputNlsCode.equals(NLS_FRA) || this.inputNlsCode.equals(NLS_ITA) || this.inputNlsCode.equals(NLS_PTB) || this.inputNlsCode.equals(NLS_KOR) || this.inputNlsCode.equals(NLS_JPN) || this.inputNlsCode.equals(NLS_CHS) || this.inputNlsCode.equals(NLS_CHT) || this.inputNlsCode.equals(NLS_RUS) || this.inputNlsCode.equals(NLS_CZE) || this.inputNlsCode.equals(NLS_PLK) || this.inputNlsCode.equals(NLS_HUN) || this.inputNlsCode.equals(NLS_ARA) ? this.inputNlsCode : NLS_ENU;
            this.setLocaleFromNlsCode();
        }
        this.setLanguageID();
    }

    public void switchLocale(Locale loc) {
        this.inputNlsCode = null;
        this.inputLocale = loc;
        if (!this.locale.equals(loc)) {
            this.locale = loc;
            this.setNlsCodeFromLocale();
            this.setLanguageID();
            this.decimalFormatSymbols = null;
            this.decimalSymbol = (char)65535;
            this.monetaryDecimalSeparator = (char)65535;
            this.currencySymbol = null;
            this.separatorSymbol = (char)65535;
            this.shortGregorianDateMask = null;
            this.longGregorianDateMask = null;
            this.shortJulianDateMask = null;
            this.longJulianDateMask = null;
            this.dateFormatter = null;
            this.userMessages = null;
            this.eglMessages = null;
        }
    }

    public String getInfo() {
        String inputLocaleText = null;
        if (this.inputLocale != null) {
            inputLocaleText = String.valueOf(this.inputLocale.getLanguage()) + "." + this.inputLocale.getCountry();
        }
        return "NLS code: " + this.nlsCode + " (" + this.inputNlsCode + "), Locale: " + this.locale + " (" + inputLocaleText + ')';
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getNlsCode() {
        return this.nlsCode;
    }

    private void setNlsCodeFromLocale() {
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        this.nlsCode = language.equals("en") ? NLS_ENU : (language.equals("de") ? (country.equals("CH") ? NLS_DES : NLS_DEU) : (language.equals("es") ? NLS_ESP : (language.equals("pt") ? NLS_PTB : (language.equals("ko") ? NLS_KOR : (language.equals("fr") ? NLS_FRA : (language.equals("it") ? NLS_ITA : (language.equals("ja") ? NLS_JPN : (language.equals("zh") ? (country.equals("TW") || country.equals("HK") ? NLS_CHT : NLS_CHS) : (language.equals("ru") ? NLS_RUS : (language.equals("pl") ? NLS_PLK : (language.equals("hu") ? NLS_HUN : (language.equals("cs") ? NLS_CZE : (language.equals("ar") ? NLS_ARA : NLS_ENU)))))))))))));
    }

    private void setLocaleFromNlsCode() {
        this.locale = LocalizedText.getLocaleFromNlsCode(this.nlsCode);
    }

    public static Locale getLocaleFromNlsCode(String nlsCode) {
        Locale locale = nlsCode.equals(NLS_ENU) ? Locale.US : (nlsCode.equals(NLS_DEU) ? Locale.GERMAN : (nlsCode.equals(NLS_DES) ? new Locale("de", "CH", "") : (nlsCode.equals(NLS_ESP) ? new Locale("es", "", "") : (nlsCode.equals(NLS_FRA) ? Locale.FRENCH : (nlsCode.equals(NLS_ITA) ? Locale.ITALIAN : (nlsCode.equals(NLS_PTB) ? new Locale("pt", "BR", "") : (nlsCode.equals(NLS_KOR) ? Locale.KOREAN : (nlsCode.equals(NLS_JPN) ? Locale.JAPANESE : (nlsCode.equals(NLS_CHS) ? Locale.SIMPLIFIED_CHINESE : (nlsCode.equals(NLS_CHT) ? Locale.TRADITIONAL_CHINESE : (nlsCode.equals(NLS_RUS) ? new Locale("ru", "", "") : (nlsCode.equals(NLS_PLK) ? new Locale("pl", "", "") : (nlsCode.equals(NLS_HUN) ? new Locale("hu", "", "") : (nlsCode.equals(NLS_CZE) ? new Locale("cs", "", "") : (nlsCode.equals(NLS_ARA) ? new Locale("ar", "", "") : Locale.getDefault())))))))))))))));
        return locale;
    }

    public String getCurrencySymbol() {
        if (this.currencySymbol != null) {
            return this.currencySymbol;
        }
        this.currencySymbol = this.properties.get("egl.nls.currency");
        if (this.currencySymbol != null) {
            return this.currencySymbol;
        }
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        this.currencySymbol = this.decimalFormatSymbols.getCurrencySymbol();
        return this.currencySymbol;
    }

    public int getCurrencyLocation() {
        if (this.currencyLocation != -1) {
            return this.currencyLocation;
        }
        String property = this.properties.get("egl.nls.currency.location");
        this.currencyLocation = property != null ? (property.equals("FRONT") ? 1 : (property.equals("BACK") ? 2 : 0)) : 0;
        return this.currencyLocation;
    }

    public char getDecimalSymbol() {
        if (this.decimalSymbol != '\uffff') {
            return this.decimalSymbol;
        }
        String decimalString = this.properties.get("egl.nls.number.decimal");
        if (decimalString != null && decimalString.length() > 0) {
            this.decimalSymbol = decimalString.charAt(0);
            this.decimalSymbolSetInProperties = true;
            return this.decimalSymbol;
        }
        this.decimalSymbolSetInProperties = false;
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        this.decimalSymbol = this.decimalFormatSymbols.getDecimalSeparator();
        return this.decimalSymbol;
    }

    public char getMonetaryDecimalSeparator() {
        if (this.monetaryDecimalSeparator != '\uffff') {
            return this.monetaryDecimalSeparator;
        }
        this.getDecimalSymbol();
        if (this.decimalSymbolSetInProperties) {
            this.monetaryDecimalSeparator = this.decimalSymbol;
            return this.monetaryDecimalSeparator;
        }
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        this.monetaryDecimalSeparator = this.decimalFormatSymbols.getMonetaryDecimalSeparator();
        return this.monetaryDecimalSeparator;
    }

    public static boolean isGregorianDateMask(String mask, boolean shortFormat) {
        char quoteChar = '\'';
        int count_y = 0;
        int count_m = 0;
        int count_d = 0;
        int count_separator = 0;
        boolean inQuote = false;
        int length = mask.length();
        int i = 0;
        while (i < length) {
            char ch;
            if ((ch = mask.charAt(i++)) == quoteChar) {
                if (i < length && (ch = mask.charAt(i)) == quoteChar) {
                    ++count_separator;
                    ++i;
                    continue;
                }
                if (!inQuote) {
                    inQuote = true;
                    continue;
                }
                inQuote = false;
                continue;
            }
            if (inQuote) {
                ++count_separator;
                continue;
            }
            if (ch == 'y') {
                ++count_y;
                continue;
            }
            if (ch == 'M') {
                ++count_m;
                continue;
            }
            if (ch == 'd') {
                ++count_d;
                continue;
            }
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                return false;
            }
            ++count_separator;
        }
        return count_d == 2 && count_m == 2 && count_y == (shortFormat ? 2 : 4) && count_separator == 2;
    }

    private static boolean isJulianDateMask(String mask, boolean shortFormat) {
        char quoteChar = '\'';
        int count_y = 0;
        int count_d = 0;
        int count_separator = 0;
        boolean inQuote = false;
        int length = mask.length();
        int i = 0;
        while (i < length) {
            char ch;
            if ((ch = mask.charAt(i++)) == quoteChar) {
                if (i < length && (ch = mask.charAt(i)) == quoteChar) {
                    ++count_separator;
                    ++i;
                    continue;
                }
                if (!inQuote) {
                    inQuote = true;
                    continue;
                }
                inQuote = false;
                continue;
            }
            if (inQuote) {
                ++count_separator;
                continue;
            }
            if (ch == 'y') {
                ++count_y;
                continue;
            }
            if (ch == 'D') {
                ++count_d;
                continue;
            }
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                return false;
            }
            ++count_separator;
        }
        return count_d == 3 && count_y == (shortFormat ? 2 : 4) && count_separator == 1;
    }

    public String getLongGregorianDateMask() {
        SimpleDateFormat sdf;
        if (this.longGregorianDateMask != null) {
            return this.longGregorianDateMask;
        }
        String mask = this.properties.get("egl.datemask.gregorian.long." + this.nlsCode);
        int style = 2;
        if (mask != null) {
            if (mask.equals("short")) {
                style = 3;
            } else if (mask.equals("medium")) {
                style = 2;
            } else if (mask.equals("long")) {
                style = 1;
            } else if (LocalizedText.isGregorianDateMask(mask, false)) {
                this.longGregorianDateMask = mask;
                return mask;
            }
        }
        DateFormat formatter = DateFormat.getDateInstance(style, this.locale);
        String def = "MM-dd-yyyy";
        try {
            sdf = (SimpleDateFormat)formatter;
        }
        catch (ClassCastException classCastException) {
            return def;
        }
        mask = LocalizedText.parseDateFormatPattern(sdf.toPattern(), false);
        if (LocalizedText.isGregorianDateMask(mask, false)) {
            this.longGregorianDateMask = mask;
            return mask;
        }
        this.longGregorianDateMask = def;
        return def;
    }

    public String getLongJulianDateMask() {
        SimpleDateFormat sdf;
        if (this.longJulianDateMask != null) {
            return this.longJulianDateMask;
        }
        String mask = this.properties.get("egl.datemask.julian.long." + this.nlsCode);
        int style = 2;
        if (mask != null) {
            if (mask.equals("short")) {
                style = 3;
            } else if (mask.equals("medium")) {
                style = 2;
            } else if (mask.equals("long")) {
                style = 1;
            } else if (LocalizedText.isJulianDateMask(mask, false)) {
                this.longJulianDateMask = mask;
                return mask;
            }
        }
        DateFormat formatter = DateFormat.getDateInstance(style, this.locale);
        String def = "yyyy-DDD";
        try {
            sdf = (SimpleDateFormat)formatter;
        }
        catch (ClassCastException classCastException) {
            return def;
        }
        mask = LocalizedText.parseDateFormatPattern(sdf.toPattern(), false);
        if (LocalizedText.isJulianDateMask(mask, false)) {
            this.longJulianDateMask = mask;
            return mask;
        }
        this.longJulianDateMask = def;
        return def;
    }

    public char getSeparatorSymbol() {
        if (this.separatorSymbol != '\uffff') {
            return this.separatorSymbol;
        }
        String separatorString = this.properties.get("egl.nls.number.separator");
        if (separatorString != null && separatorString.length() > 0) {
            this.separatorSymbol = separatorString.charAt(0);
            return this.separatorSymbol;
        }
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        this.separatorSymbol = this.decimalFormatSymbols.getGroupingSeparator();
        return this.separatorSymbol;
    }

    public String getShortGregorianDateMask() {
        SimpleDateFormat sdf;
        if (this.shortGregorianDateMask != null) {
            return this.shortGregorianDateMask;
        }
        String def = "MM-dd-yy";
        String mask = this.properties.get("egl.datemask.gregorian.short." + this.nlsCode);
        if (mask != null && LocalizedText.isGregorianDateMask(mask, true)) {
            this.shortGregorianDateMask = mask;
            return mask;
        }
        DateFormat formatter = DateFormat.getDateInstance(3, this.locale);
        try {
            sdf = (SimpleDateFormat)formatter;
        }
        catch (ClassCastException classCastException) {
            return def;
        }
        mask = LocalizedText.parseDateFormatPattern(sdf.toPattern(), true);
        if (LocalizedText.isGregorianDateMask(mask, true)) {
            this.shortGregorianDateMask = mask;
            return mask;
        }
        this.shortGregorianDateMask = def;
        return def;
    }

    public String getShortJulianDateMask() {
        SimpleDateFormat sdf;
        if (this.shortJulianDateMask != null) {
            return this.shortJulianDateMask;
        }
        String def = "yy-DDD";
        String mask = this.properties.get("egl.datemask.julian.short." + this.nlsCode);
        if (mask != null && LocalizedText.isJulianDateMask(mask, true)) {
            this.shortJulianDateMask = mask;
            return mask;
        }
        DateFormat formatter = DateFormat.getDateInstance(3, this.locale);
        try {
            sdf = (SimpleDateFormat)formatter;
        }
        catch (ClassCastException classCastException) {
            return def;
        }
        mask = LocalizedText.parseDateFormatPattern(sdf.toPattern(), true);
        if (LocalizedText.isJulianDateMask(mask, true)) {
            this.shortJulianDateMask = mask;
            return mask;
        }
        this.shortJulianDateMask = def;
        return def;
    }

    public boolean isSingleByteLanguage() {
        switch (this.languageID) {
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public boolean isAsciiSingleByteChar(byte b) {
        switch (this.languageID) {
            case 1: 
            case 2: {
                return b < -127 || -2 < b;
            }
            case 9: {
                return b < -127 || -97 < b && b < -32 || -4 < b;
            }
            case 10: {
                return b < -113 || -2 < b;
            }
        }
        return true;
    }

    public static String parseDateFormatPattern(String pattern, boolean shortFormat) {
        char quoteChar = '\'';
        StringBuilder buf = new StringBuilder();
        int count_y = 0;
        int count_m = 0;
        int count_d = 0;
        int count_D = 0;
        boolean inQuote = false;
        int length = pattern.length();
        int i = 0;
        while (i < length) {
            char ch;
            if ((ch = pattern.charAt(i++)) == quoteChar) {
                buf.append(ch);
                if (i < length && (ch = pattern.charAt(i)) == quoteChar) {
                    buf.append(ch);
                    ++i;
                    continue;
                }
                if (!inQuote) {
                    inQuote = true;
                    continue;
                }
                inQuote = false;
                continue;
            }
            if (inQuote) {
                buf.append(ch);
                continue;
            }
            if (ch == 'y') {
                if (count_y == 0) {
                    if (shortFormat) {
                        buf.append("yy");
                    } else {
                        buf.append("yyyy");
                    }
                }
                ++count_y;
                continue;
            }
            if (ch == 'M') {
                if (count_m == 0) {
                    buf.append("MM");
                }
                ++count_m;
                continue;
            }
            if (ch == 'd') {
                if (count_d == 0) {
                    buf.append("dd");
                }
                ++count_d;
                continue;
            }
            if (ch == 'D') {
                if (count_D == 0) {
                    buf.append("DDD");
                }
                ++count_D;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    private void setLanguageID() {
        this.languageID = this.nlsCode.equals(NLS_CHS) ? 1 : (this.nlsCode.equals(NLS_CHT) ? 2 : (this.nlsCode.equals(NLS_DES) ? 3 : (this.nlsCode.equals(NLS_DEU) ? 4 : (this.nlsCode.equals(NLS_ENU) ? 5 : (this.nlsCode.equals(NLS_ESP) ? 6 : (this.nlsCode.equals(NLS_FRA) ? 7 : (this.nlsCode.equals(NLS_ITA) ? 8 : (this.nlsCode.equals(NLS_JPN) ? 9 : (this.nlsCode.equals(NLS_KOR) ? 10 : (this.nlsCode.equals(NLS_PTB) ? 11 : (this.nlsCode.equals(NLS_RUS) ? 12 : (this.nlsCode.equals(NLS_PLK) ? 15 : (this.nlsCode.equals(NLS_HUN) ? 13 : (this.nlsCode.equals(NLS_CZE) ? 14 : (this.nlsCode.equals(NLS_ARA) ? 16 : 5)))))))))))))));
    }

    public int getLanguageID() {
        return this.languageID;
    }

    public String getMessage(String id) {
        if (this.eglMessages == null) {
            boolean userMessagesMissing = false;
            String userMessagesFile = this.properties.get("egl.messages.file");
            if (userMessagesFile != null) {
                this.userMessages = (ResourceBundle)bundleCache.get(String.valueOf(userMessagesFile) + this.locale);
                if (this.userMessages == null) {
                    try {
                        this.userMessages = ResourceBundle.getBundle(userMessagesFile, this.locale);
                        bundleCache.put(String.valueOf(userMessagesFile) + this.locale, this.userMessages);
                    }
                    catch (MissingResourceException missingResourceException) {
                        userMessagesMissing = true;
                    }
                }
            }
            this.eglMessages = (ResourceBundle)bundleCache.get(this.locale);
            if (this.eglMessages == null) {
                this.eglMessages = ResourceBundle.getBundle("org.eclipse.edt.javart.messages.MessageBundle", this.locale);
                bundleCache.put(this.locale, this.eglMessages);
            }
            if (userMessagesMissing) {
                String text = this.getMessageText("EGL0035E");
                MessageFormat mf = new MessageFormat(text, this.locale);
                return mf.format(new Object[]{String.valueOf(userMessagesFile) + ".properties"});
            }
        }
        return this.getMessageText(id);
    }

    private String getMessageText(String id) {
        if (this.userMessages != null) {
            try {
                return this.userMessages.getString(id);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        try {
            return this.eglMessages.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public DateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = DateFormat.getDateTimeInstance(2, 2, this.locale);
        }
        return this.dateFormatter;
    }

    public String getMessage(String id, Object ... inserts) {
        String text = this.getMessage(id);
        if (inserts == null || text == null || inserts.length == 0) {
            return text;
        }
        MessageFormat mf = new MessageFormat(text, this.locale);
        return mf.format(inserts);
    }
}

