/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugElement;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.debug.javascript.internal.model.RUIStackFrame;
import org.eclipse.osgi.util.NLS;

public class RUIThread
extends RUIDebugElement
implements IEGLThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;

    public RUIThread(RUIDebugTarget target) {
        super(target);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == RUIThread.class || adapter == IThread.class || adapter == IEGLThread.class) {
            return this;
        }
        if (adapter == RUIStackFrame.class || adapter == IStackFrame.class || adapter == IEGLStackFrame.class) {
            return this.getTopStackFrame();
        }
        return super.getAdapter(adapter);
    }

    public IStackFrame[] getStackFrames() {
        if (this.isSuspended()) {
            return ((RUIDebugTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.isTerminated() && this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        String threadName = RUIDebugMessages.rui_thread_thread_name;
        String label = null;
        if (this.isTerminated()) {
            label = NLS.bind((String)RUIDebugMessages.rui_thread_label_terminated, (Object)threadName);
        } else if (this.isStepping()) {
            label = NLS.bind((String)RUIDebugMessages.rui_thread_label_stepping, (Object)threadName);
        } else if (this.isSuspended()) {
            EGLBreakpoint breakpoint = this.getCurrentUserBreakpoint();
            if (breakpoint == null) {
                label = NLS.bind((String)RUIDebugMessages.rui_thread_label_suspended, (Object)threadName);
            } else {
                IMarker marker = breakpoint.getMarker();
                int line = marker.getAttribute("lineNumber", -1);
                Object[] args = new String[]{threadName, Integer.toString(line), marker.getResource().getName()};
                label = NLS.bind((String)RUIDebugMessages.rui_thread_label_suspendedAtBreakpoint, (Object[])args);
            }
        } else {
            label = NLS.bind((String)RUIDebugMessages.rui_thread_label_running, (Object)threadName);
        }
        return label;
    }

    protected EGLBreakpoint getCurrentUserBreakpoint() {
        if (this.fBreakpoints != null && this.fBreakpoints.length != 0) {
            return (EGLBreakpoint)this.fBreakpoints[0];
        }
        return null;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.fBreakpoints = null;
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended() && !((RUIDebugTarget)this.getDebugTarget()).isTerminating();
    }

    public boolean canStepOver() {
        return this.isSuspended() && !((RUIDebugTarget)this.getDebugTarget()).isTerminating();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && !((RUIDebugTarget)this.getDebugTarget()).isTerminating();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        this.fBreakpoints = null;
        ((RUIDebugTarget)this.getDebugTarget()).stepIn();
    }

    public void stepOver() throws DebugException {
        this.stepOver((RUIStackFrame)this.getTopStackFrame());
    }

    protected void stepOver(RUIStackFrame frame) {
        this.fBreakpoints = null;
        ((RUIDebugTarget)this.getDebugTarget()).stepOver(frame);
    }

    public void stepReturn() throws DebugException {
        this.stepReturn((RUIStackFrame)this.getTopStackFrame());
    }

    protected void stepReturn(RUIStackFrame frame) {
        this.fBreakpoints = null;
        ((RUIDebugTarget)this.getDebugTarget()).stepOut(frame);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }
}

