/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java.filters;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.AbstractTypeFilter;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class ClasspathEntryFilter
extends AbstractTypeFilter {
    private boolean commonClassesProcessed;
    protected Map<String, Object> commonClassesToFilter;
    protected Map<Object, Map<String, Object>> targetClassMap = new HashMap<Object, Map<String, Object>>();

    @Override
    public boolean filter(IJavaStackFrame frame, IEGLJavaDebugTarget target) {
        Map<String, Object> classMap;
        String typeName;
        block4: {
            try {
                typeName = frame.getReferenceType().getName();
                if (this.commonClassesToFilter == null || !this.commonClassesToFilter.containsKey(typeName)) break block4;
                return true;
            }
            catch (DebugException debugException) {}
        }
        Object targetKey = this.getTargetClassmapKey(target);
        if (targetKey != null && (classMap = this.targetClassMap.get(targetKey)) != null) {
            return classMap.containsKey(typeName);
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.commonClassesToFilter = null;
        this.targetClassMap = null;
    }

    @Override
    public void dispose(IEGLJavaDebugTarget target) {
        super.dispose(target);
        if (this.targetClassMap != null) {
            this.targetClassMap.remove(target);
        }
    }

    @Override
    public synchronized void initialize(IEGLJavaDebugTarget target) {
        Object targetKey;
        IJavaProject jp = null;
        if (!this.commonClassesProcessed) {
            this.commonClassesProcessed = true;
            try {
                IClasspathEntry[] entries = this.getCommonClasspathEntries();
                if (entries != null && entries.length > 0) {
                    jp = JavaRuntime.getJavaProject((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
                    this.commonClassesToFilter = new HashMap<String, Object>(100);
                    this.processEntries(entries, jp, this.commonClassesToFilter);
                }
            }
            catch (Exception e) {
                EDTDebugCorePlugin.log(e);
            }
        }
        if ((targetKey = this.getTargetClassmapKey(target)) == null || this.targetClassMap.containsKey(targetKey)) {
            return;
        }
        this.targetClassMap.put(targetKey, null);
        try {
            IClasspathEntry[] entries = this.getTargetClasspathEntries(target);
            if (entries != null && entries.length > 0) {
                if (jp == null) {
                    jp = JavaRuntime.getJavaProject((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
                }
                HashMap<String, Object> targetClasses = new HashMap<String, Object>(100);
                this.targetClassMap.put(target, targetClasses);
                this.processEntries(entries, jp, targetClasses);
            }
        }
        catch (Exception e) {
            EDTDebugCorePlugin.log(e);
        }
    }

    protected void processEntries(IClasspathEntry[] entries, IJavaProject project, Map<String, Object> classMap) throws CoreException {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 1: {
                    this.processLibraryEntry(entry, classMap);
                    break;
                }
                case 5: {
                    this.processContainerEntry(entry, project, classMap);
                    break;
                }
                case 3: {
                    this.processSourceEntry(entry, classMap);
                    break;
                }
                case 2: {
                    IProject depProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment());
                    if (!depProject.isAccessible() || !depProject.hasNature("org.eclipse.jdt.core.javanature")) break;
                    IJavaProject jp = JavaCore.create((IProject)depProject);
                    this.processEntries(jp.getResolvedClasspath(true), jp, classMap);
                    break;
                }
                default: {
                    EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterClasspathEntryNotSupported, (Object[])new Object[]{entry.getEntryKind(), this.getId()})));
                }
            }
            ++n2;
        }
    }

    protected void processSourceEntry(IClasspathEntry entry, Map<String, Object> classMap) {
        File file;
        IPath abs;
        IResource resource;
        IPath output = entry.getOutputLocation();
        if (output == null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    output = JavaCore.create((IProject)project).getOutputLocation();
                }
            }
            catch (CoreException ce) {
                EDTDebugCorePlugin.log(ce);
            }
        }
        if (output != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(output)) != null && (abs = resource.getLocation()) != null && (file = abs.toFile()).isDirectory()) {
            String rootPath = file.getPath();
            if (!rootPath.endsWith(File.separator)) {
                rootPath = String.valueOf(rootPath) + File.separator;
            }
            this.processDirectory(file, rootPath, classMap);
        }
    }

    protected void processLibraryEntry(IClasspathEntry entry, Map<String, Object> classMap) {
        File file = entry.getPath().toFile();
        if (file.exists()) {
            if (file.isDirectory()) {
                String rootPath = file.getPath();
                if (!rootPath.endsWith(File.separator)) {
                    rootPath = String.valueOf(rootPath) + File.separator;
                }
                this.processDirectory(file, rootPath, classMap);
            } else if (file.getName().endsWith(".jar")) {
                this.processJar(file, null, classMap);
            }
        }
    }

    protected void processJar(File file, String rootPath, Map<String, Object> classMap) {
        int rootPathLen = rootPath == null ? 0 : rootPath.length();
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String path;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(path = entry.getName()).endsWith(".class")) continue;
                String className = path.substring(rootPathLen, path.length() - 6).replace('/', '.');
                classMap.put(className, null);
            }
        }
        catch (IOException ioe) {
            EDTCoreIDEPlugin.log((Throwable)ioe);
        }
    }

    protected void processDirectory(File dir, String pathRoot, Map<String, Object> classMap) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String path = file.getPath();
                if (path.endsWith(".class")) {
                    String className = path.substring(pathRoot.length(), path.length() - 6).replace(File.separatorChar, '.');
                    classMap.put(className, null);
                }
            } else {
                this.processDirectory(file, pathRoot, classMap);
            }
            ++n2;
        }
    }

    protected void processContainerEntry(IClasspathEntry entry, IJavaProject project, Map<String, Object> classMap) {
        IPackageFragmentRoot[] roots;
        if (project == null) {
            return;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.findPackageFragmentRoots(entry);
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                IJavaElement[] iJavaElementArray = root.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    if (element.getElementType() == 4) {
                        try {
                            IClassFile[] classes;
                            IPackageFragment pkg = (IPackageFragment)element;
                            StringBuilder pkgBuf = new StringBuilder(50);
                            IPackageFragment current = pkg;
                            while (current != null && current.getElementType() == 4) {
                                if (pkgBuf.length() > 0) {
                                    pkgBuf.insert(0, '.');
                                }
                                pkgBuf.insert(0, current.getElementName());
                                current = current.getParent();
                            }
                            String pkgString = pkgBuf.toString();
                            IClassFile[] iClassFileArray = classes = pkg.getClassFiles();
                            int n5 = classes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IClassFile file = iClassFileArray[n6];
                                String className = file.getElementName();
                                className = className.substring(0, className.length() - 6);
                                StringBuilder buf = new StringBuilder(pkgString.length() + className.length() + 1);
                                buf.append(pkgString);
                                if (pkgString.length() > 0) {
                                    buf.append('.');
                                }
                                buf.append(className);
                                classMap.put(buf.toString(), null);
                                ++n6;
                            }
                        }
                        catch (JavaModelException jme) {
                            EDTDebugCorePlugin.log(jme);
                        }
                    }
                    ++n4;
                }
            }
            catch (JavaModelException jme) {
                EDTDebugCorePlugin.log(jme);
            }
            ++n2;
        }
    }

    protected IClasspathEntry[] getCommonClasspathEntries() throws CoreException {
        return null;
    }

    protected IClasspathEntry[] getTargetClasspathEntries(IEGLJavaDebugTarget target) throws CoreException {
        return null;
    }

    protected Object getTargetClassmapKey(IEGLJavaDebugTarget target) {
        return target;
    }
}

