/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DebugUtil {
    public static final char[] SUFFIX_egl = ".egl".toCharArray();
    public static final char[] SUFFIX_EGL = ".EGL".toCharArray();

    private DebugUtil() {
    }

    public static final boolean isEGLFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_EGL.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_egl[i] && c != SUFFIX_EGL[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                shell[0] = display.getActiveShell();
            }
        });
        return shell[0];
    }

    public static IResource getContext() {
        IWorkbenchPage page = EDTUIPlugin.getActivePage();
        if (page != null) {
            ISelection selection = page.getSelection();
            Object element = null;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (!sel.isEmpty()) {
                    element = sel.getFirstElement();
                }
            } else {
                element = selection;
            }
            if (element != null && element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
                return (IResource)element;
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IEditorInput input = part.getEditorInput();
                return (IResource)input.getAdapter(IResource.class);
            }
        }
        return null;
    }
}

