/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class IFilePartInfo
extends PartInfo {
    private final String fProject;
    private final String fFolder;
    private final String fFile;
    private final String fExtension;
    private final char fPartType;
    public static final int EGLAR_FILE = 1;
    public static final int EGL_FILE = 2;
    private final String fContainerLoc;
    private boolean isExternal;

    public IFilePartInfo(String pkg, String name, char[][] enclosingTypes, String project, String sourceFolder, String file, String extension, char partType) {
        super(pkg, name, enclosingTypes);
        this.fProject = project;
        this.fFolder = sourceFolder;
        this.fFile = file;
        this.fExtension = extension;
        this.fPartType = partType;
        this.fContainerLoc = null;
        this.isExternal = false;
    }

    public IFilePartInfo(String pkg, String name, char[][] enclosingTypes, String project, String containerLocation, String sourceFolder, String file, String extension, char partType, boolean isExternal) {
        super(pkg, name, enclosingTypes);
        this.fProject = project;
        this.fFolder = sourceFolder;
        this.fContainerLoc = containerLocation;
        this.fFile = file;
        this.fExtension = extension;
        this.fPartType = partType;
        this.isExternal = isExternal;
    }

    @Override
    public int getElementType() {
        return 3;
    }

    @Override
    protected IEGLElement getEGLElement(IEGLSearchScope scope) {
        IResource iResource = null;
        if (Util.isEGLARFileName(this.fFolder)) {
            iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.fProject));
            if (iResource == null) {
                return null;
            }
            IClassFile classFile = IFilePartInfo.getClassFile(iResource, this.fPackage, 1, String.valueOf(this.fFile) + "." + this.fExtension);
            return classFile;
        }
        iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getPath()));
        return EGLCore.create(iResource);
    }

    public static IPackageFragment getPackageFragment(IResource iResource, String packageName) {
        try {
            IPackageFragment[] fragments;
            IEGLProject eglProject = EGLCore.create(iResource.getProject());
            IPackageFragment[] iPackageFragmentArray = fragments = eglProject.getPackageFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (fragment.getElementName().equalsIgnoreCase(packageName)) {
                    return fragment;
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IPackageFragment getPackageFragment(IResource iResource, String packageName, int fileType) {
        try {
            IPackageFragment[] fragments;
            IEGLProject eglProject = EGLCore.create(iResource.getProject());
            IPackageFragment[] iPackageFragmentArray = fragments = eglProject.getPackageFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (!(fileType == 2 && fragment instanceof EglarPackageFragment || fileType == 1 && !(fragment instanceof EglarPackageFragment) || !fragment.getElementName().equalsIgnoreCase(packageName))) {
                    return fragment;
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static IPackageFragment[] getPackageFragments(IResource iResource, String packageName, int fileType) {
        try {
            IPackageFragment[] fragments;
            ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
            IEGLProject eglProject = EGLCore.create(iResource.getProject());
            IPackageFragment[] iPackageFragmentArray = fragments = eglProject.getPackageFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                if (!(fileType == 2 && fragment instanceof EglarPackageFragment || fileType == 1 && !(fragment instanceof EglarPackageFragment) || !fragment.getElementName().equalsIgnoreCase(packageName))) {
                    list.add(fragment);
                }
                ++n2;
            }
            return list.toArray(new IPackageFragment[list.size()]);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IClassFile getClassFile(IResource iResource, String packageName, int fileType, String classFileName) {
        IPackageFragment[] frags = IFilePartInfo.getPackageFragments(iResource, packageName, fileType);
        if (frags == null) {
            return null;
        }
        int i = 0;
        while (i < frags.length) {
            IClassFile cFile = frags[i].getClassFile(classFileName);
            if (cFile != null && cFile.exists() && cFile.getPart() != null) {
                return cFile;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IPath getPackageFragmentRootPath() {
        StringBuffer buffer = new StringBuffer(this.fProject);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            if (!this.isExternal) {
                buffer.append('/');
            } else {
                buffer.append(File.separator);
            }
            buffer.append(this.fFolder);
        }
        return new Path(buffer.toString());
    }

    @Override
    public String getPath() {
        StringBuffer result = new StringBuffer(String.valueOf(Util.isEGLARFileName(this.fFolder) ? "eglar://" : "") + this.fContainerLoc);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            if (!this.isExternal) {
                result.append('/');
            } else {
                result.append(File.separator);
            }
            result.append(this.fFolder);
        }
        if (Util.isEGLARFileName(this.fFolder)) {
            result.append("|");
        }
        result.append('/');
        String packageName = this.getPackageName();
        if (!"".equals(packageName)) {
            result.append(packageName.replace('.', '/'));
            result.append('/');
        }
        result.append(this.fFile);
        result.append('.');
        result.append(this.fExtension);
        return result.toString();
    }

    public String getContainerPath() {
        StringBuffer buffer = new StringBuffer(this.fContainerLoc);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            if (!this.isExternal) {
                buffer.append('/');
            } else {
                buffer.append(File.separator);
            }
            buffer.append(this.fFolder);
        }
        return buffer.toString();
    }

    public String getProject() {
        return this.fProject;
    }

    public String getFolder() {
        return this.fFolder;
    }

    public String getFileName() {
        return this.fFile;
    }

    public String getExtension() {
        return this.fExtension;
    }

    @Override
    public char getPartType() {
        return this.fPartType;
    }

    public boolean isExternal() {
        return this.isExternal;
    }
}

