/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.CopyResourceElementsOperation;
import org.eclipse.edt.ide.core.internal.model.DeleteResourceElementsOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.MoveResourceElementsOperation;
import org.eclipse.edt.ide.core.internal.model.MultiOperation;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.RenameResourceElementsOperation;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;

public class EGLModel
extends Openable
implements IEGLModel {
    public static HashSet existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFiles = new HashSet();

    protected EGLModel() throws Error {
        super(1, null, "");
    }

    @Override
    public boolean contains(IResource resource) {
        IEGLProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getEGLProjects();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            EGLProject project = (EGLProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void copy(IEGLElement[] elements, IEGLElement[] containers, IEGLElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (elements == null || elements.length <= 0 || elements[0] == null || elements[0].getElementType() >= 8) {
            throw new UnsupportedOperationException();
        }
        this.runOperation(new CopyResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new EGLModelInfo();
    }

    @Override
    public void delete(IEGLElement[] elements, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() <= 6) {
            new DeleteResourceElementsOperation(elements, force).runOperation(monitor);
        }
    }

    public IEGLProject findEGLProject(IProject project) {
        try {
            IEGLProject[] projects = this.getOldEGLProjectsList();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IEGLProject eglProject = projects[i];
                if (project.equals((Object)eglProject.getProject())) {
                    return eglProject;
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return null;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFiles = new HashSet();
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        EGLModelManager.getEGLModelManager().putInfo(this, info);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject project = projects[i];
            if (EGLProject.hasEGLNature(project)) {
                info.addChild(this.getEGLProject((IResource)project));
            }
            ++i;
        }
        return true;
    }

    protected IPackageFragmentRoot getHandleFromMementoForRoot(String memento, EGLProject project, int projectEnd, int rootEnd) {
        String rootName = null;
        rootName = rootEnd == projectEnd - 1 ? "" : memento.substring(projectEnd + 1, rootEnd);
        return project.getPackageFragmentRoot((IPath)new Path(rootName));
    }

    protected IEGLElement getHandleFromMementoForSourceMembers(String memento, IPackageFragmentRoot root, int rootEnd, int end) throws EGLModelException {
        IPackageFragment frag = null;
        frag = rootEnd == end - 1 ? root.getPackageFragment("") : root.getPackageFragment(memento.substring(rootEnd + 1, end));
        int oldEnd = end;
        if ((end = memento.indexOf(37, end)) != -1) {
            IEGLFile cu = frag.getEGLFile(memento.substring(oldEnd + 1, end));
            return cu.getPackageDeclaration(memento.substring(end + 1));
        }
        end = memento.indexOf(39, oldEnd);
        if (end != -1) {
            IEGLFile cu = frag.getEGLFile(memento.substring(oldEnd + 1, end));
            return cu.getImport(memento.substring(end + 1));
        }
        int typeStart = memento.indexOf(91, oldEnd);
        if (typeStart == -1) {
            return frag.getEGLFile(memento.substring(oldEnd + 1));
        }
        IEGLFile cu = frag.getEGLFile(memento.substring(oldEnd + 1, typeStart));
        end = memento.indexOf(94, oldEnd);
        if (end != -1) {
            IPart type = this.getHandleFromMementoForSourcePart(memento, cu, typeStart, end);
            return type.getField(memento.substring(end + 1));
        }
        end = memento.indexOf(126, oldEnd);
        if (end != -1) {
            String methodName;
            IPart type = this.getHandleFromMementoForSourcePart(memento, cu, typeStart, end);
            oldEnd = end;
            end = memento.lastIndexOf(126);
            String[] parameterTypes = null;
            if (end == oldEnd) {
                methodName = memento.substring(end + 1);
                parameterTypes = new String[]{};
            } else {
                String parameters = memento.substring(oldEnd + 1);
                StringTokenizer mTokenizer = new StringTokenizer(parameters, new String(new char[]{'~'}));
                parameterTypes = new String[mTokenizer.countTokens() - 1];
                methodName = mTokenizer.nextToken();
                int i = 0;
                while (mTokenizer.hasMoreTokens()) {
                    parameterTypes[i] = mTokenizer.nextToken();
                    ++i;
                }
            }
            return type.getFunction(methodName, parameterTypes);
        }
        return this.getHandleFromMementoForSourcePart(memento, cu, typeStart, memento.length());
    }

    protected IPart getHandleFromMementoForSourcePart(String memento, IEGLFile cu, int typeStart, int typeEnd) throws EGLModelException {
        int end = memento.lastIndexOf(91);
        IPart type = null;
        if (end == typeStart) {
            String typeName = memento.substring(typeStart + 1, typeEnd);
            type = cu.getPart(typeName);
        } else {
            String typeNames = memento.substring(typeStart + 1, typeEnd);
            StringTokenizer tokenizer = new StringTokenizer(typeNames, new String(new char[]{'['}));
            type = cu.getPart(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                type = type.getPart(tokenizer.nextToken());
            }
        }
        return type;
    }

    @Override
    public String getHandleMemento() {
        return this.getElementName();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    @Override
    public IEGLProject getEGLProject(String name) {
        return new EGLProject(ResourcesPlugin.getWorkspace().getRoot().getProject(name), this);
    }

    public IEGLProject getEGLProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new EGLProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new EGLProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new EGLProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(EGLModelResources.elementInvalidResourceForProject);
    }

    @Override
    public IEGLProject[] getEGLProjects() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(2);
        IEGLProject[] array = new IEGLProject[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public Object[] getNonEGLResources() throws EGLModelException {
        return ((EGLModelInfo)this.getElementInfo()).getNonEGLResources();
    }

    public IEGLProject[] getOldEGLProjectsList() throws EGLModelException {
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        return manager.eglProjectsCache == null ? this.getEGLProjects() : manager.eglProjectsCache;
    }

    @Override
    public IPath getPath() {
        return Path.ROOT;
    }

    @Override
    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        return null;
    }

    @Override
    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public void move(IEGLElement[] elements, IEGLElement[] containers, IEGLElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() <= 6) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    @Override
    public void rename(IEGLElement[] elements, IEGLElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws EGLModelException {
        EGLModelOperation op = null;
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() <= 6) {
            op = new RenameResourceElementsOperation(elements, destinations, renamings, force);
        }
        if (op != null) {
            op.runOperation(monitor);
        }
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return this;
    }

    protected void runOperation(MultiOperation op, IEGLElement[] elements, IEGLElement[] siblings, String[] renamings, IProgressMonitor monitor) throws EGLModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        op.runOperation(monitor);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("EGL Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    public static boolean isFile(Object target) {
        return EGLModel.getFile(target) != null;
    }

    public static synchronized File getFile(Object target) {
        File f;
        if (existingExternalConfirmedFiles.contains(target)) {
            return (File)target;
        }
        if (target instanceof File && (f = (File)target).isFile()) {
            existingExternalConfirmedFiles.add(f);
            return f;
        }
        return null;
    }
}

