/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.ETypedElement;
import org.eclipse.edt.mof.codegen.api.AbstractTemplate;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.java.MofImplConstants;

public class MofImplTemplate
extends AbstractTemplate
implements MofImplConstants {
    public EClassifier[] getReferencedTypes(EClass eClass) {
        Set<EClassifier> set = this.getReferencedTypesSet(eClass);
        return set.toArray(new EClassifier[set.size()]);
    }

    public Set<EClassifier> getReferencedTypesSet(EClass eClass) {
        HashSet<EClassifier> set = new HashSet<EClassifier>();
        set.addAll(eClass.getSuperTypes());
        for (EField field : eClass.getEFields()) {
            this.collectReferencedTypes(field, set);
        }
        for (EFunction func : eClass.getEFunctions()) {
            this.collectReferencedTypes(func, set);
            for (EParameter parm : func.getEParameters()) {
                this.collectReferencedTypes(parm, set);
            }
        }
        return set;
    }

    private void collectReferencedTypes(ETypedElement element, Set<EClassifier> set) {
        if (element.getEType() != null) {
            set.add(element.getEType().getEClassifier());
        }
        if (element.getEType() instanceof EGenericType) {
            for (EType arg : ((EGenericType)element.getEType()).getETypeArguments()) {
                set.add(arg.getEClassifier());
            }
        }
    }

    public List<EClassifier> getImportTypes(EClass eClass, boolean forImpl) {
        ArrayList<EClassifier> list = new ArrayList<EClassifier>();
        if (forImpl) {
            list.add(eClass);
        }
        for (EClassifier type : this.getReferencedTypesSet(eClass)) {
            if (!this.needsImport(type)) continue;
            if (type.getPackageName().equals(eClass.getPackageName())) {
                if (forImpl && type != eClass) {
                    list.add(type);
                    continue;
                }
                if (!(type instanceof EDataType)) continue;
                list.add(type);
                continue;
            }
            list.add(type);
        }
        return list;
    }

    public boolean needsImport(EClassifier type) {
        if (type instanceof EDataType) {
            return this.needsImport((EDataType)type);
        }
        return this.needsImport((EClass)type);
    }

    public boolean needsImport(EClassifier importType, EClass referencingClass) {
        EClass superType = this.getSuperType(referencingClass);
        return this.needsImport(importType) && superType == null ? true : !superType.getPackageName().equalsIgnoreCase(importType.getPackageName());
    }

    public boolean needsImport(EDataType type) {
        return !type.getJavaClassName().startsWith("java.lang");
    }

    public boolean needsImport(EClass eClass) {
        return eClass != null;
    }

    public EClass getSuperType(EClass eClass) {
        if (eClass.getSuperTypes().isEmpty()) {
            return null;
        }
        return eClass.getSuperTypes().get(0);
    }

    public String getterName(EField field) {
        if (field.getEType() == factory.getEBooleanEDataType()) {
            return field.getName();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("get");
        buffer.append(field.getName().substring(0, 1).toUpperCase());
        buffer.append(field.getName().substring(1));
        return buffer.toString();
    }

    public String setterName(EField field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("set");
        buffer.append(field.getName().substring(0, 1).toUpperCase());
        buffer.append(field.getName().substring(1));
        return buffer.toString();
    }

    public String getETypeSignature(EMember mbr) {
        return this.getETypeSignature(mbr.getEType());
    }

    public String getETypeSignature(EType type) {
        if (type == null) {
            return "void";
        }
        EClassifier classifier = type.getEClassifier();
        String typeSignature = this.getETypeSignature(classifier);
        if (type instanceof EGenericType) {
            typeSignature = String.valueOf(typeSignature) + "<";
            for (EType arg : ((EGenericType)type).getETypeArguments()) {
                typeSignature = String.valueOf(typeSignature) + this.getETypeSignature(arg);
            }
            typeSignature = String.valueOf(typeSignature) + ">";
        }
        return typeSignature;
    }

    public String getETypeSignature(EClassifier type, TemplateContext ctx) {
        if (type == factory.getEStringEDataType()) {
            return "java.lang.String";
        }
        if (type == factory.getEBooleanEDataType()) {
            return "java.lang.Boolean";
        }
        if (type == factory.getEIntEDataType()) {
            return "java.lang.Integer";
        }
        if (type == factory.getEListEDataType()) {
            return "java.util.List";
        }
        return String.valueOf(this.getPackageName(type, ctx)) + "." + this.getETypeName(type);
    }

    public String getETypeName(EMember mbr) {
        return this.getETypeName(mbr.getEType());
    }

    public String getETypeName(EType type) {
        if (type == null) {
            return "void";
        }
        EClassifier classifier = type.getEClassifier();
        String typeSignature = this.getETypeName(classifier);
        if (type instanceof EGenericType) {
            typeSignature = String.valueOf(typeSignature) + "<";
            for (EType arg : ((EGenericType)type).getETypeArguments()) {
                typeSignature = String.valueOf(typeSignature) + this.getETypeName(arg);
            }
            typeSignature = String.valueOf(typeSignature) + ">";
        }
        return typeSignature;
    }

    public String getETypeName(EClassifier type) {
        if (type == factory.getJavaObjectEDataType()) {
            return "Object";
        }
        if (type == factory.getEStringEDataType()) {
            return "String";
        }
        if (type == factory.getEBooleanEDataType()) {
            return "Boolean";
        }
        if (type == factory.getEIntEDataType()) {
            return "Integer";
        }
        if (type == factory.getEListEDataType()) {
            return "List";
        }
        return type.getName();
    }

    public String getPackageName(EClassifier classifier, TemplateContext ctx) {
        String packageName = (String)ctx.get(classifier.getPackageName());
        if (packageName == null) {
            return classifier.getPackageName();
        }
        return packageName;
    }
}

