/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultMessageRequestor;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.services.generators.ServiceUriMappingGenerator;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Service;

public class GenerateServiceUriMappingFileOperation
extends AbstractDeploymentOperation {
    public static final String BIND_XML_FILE_SUFFIX = "-uri.xml";
    private String targetProjectName;
    private DeploymentDesc ddModel;
    private DeploymentContext context;

    public void preCheck(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        DeploymentDesc desc;
        if (context.getStatus() != 1 && (desc = context.getDeploymentDesc()).getRestservices() != null && desc.getRestservices().size() > 0) {
            context.setStatus(1);
        }
    }

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        this.context = context;
        this.ddModel = context.getDeploymentDesc();
        List restServices = this.ddModel.getRestservices();
        DeploymentResultMessageRequestor messageRequestor = new DeploymentResultMessageRequestor(resultsCollector);
        IEGLProject eglProject = EGLCore.create((IProject)context.getSourceProject());
        int i = 0;
        while (i < restServices.size()) {
            Restservice restService = (Restservice)restServices.get(i);
            String partName = restService.getImplementation();
            try {
                Part service = context.findPart(partName);
                IPath path = eglProject.findPart(service.getFullyQualifiedName()).getEGLFile().getPath();
                IResource serviceFile = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (serviceFile != null && serviceFile.findMaxProblemSeverity(null, false, 1) == 2) {
                    messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8305", null, (String[])new String[]{service.getFullyQualifiedName()}));
                    return;
                }
                if (service instanceof Service) {
                    ServiceUriMappingGenerator generator = new ServiceUriMappingGenerator(context);
                    generator.visit((Service)service, restService);
                }
                messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8304", null, (String[])new String[]{service.getFullyQualifiedName()}));
            }
            catch (Exception e) {
                messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8305", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
            }
            ++i;
        }
    }
}

