/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.deployment.core.model.RUIApplication;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultMessageRequestor;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ConfigureRuntimePropertiesOperation
extends AbstractDeploymentOperation {
    private static final String RUNUNIT_PROPERTIES = "rununit.properties";

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        boolean deployingRUIHandlers;
        DeploymentResultMessageRequestor requestor = new DeploymentResultMessageRequestor(resultsCollector);
        Set<Part> restServices = this.findRESTServices(context, requestor);
        RUIApplication ruiApp = context.getDeploymentDesc().getRUIApplication();
        if (ruiApp.deployAllHandlers()) {
            deployingRUIHandlers = context.getSourceProject() != null ? DeploymentUtilities.getAllRUIHandlersInProject((IEGLProject)EGLCore.create((IProject)context.getSourceProject())).size() > 0 : false;
        } else {
            boolean bl = deployingRUIHandlers = ruiApp.getRUIHandlers().size() > 0;
        }
        if (deployingRUIHandlers || restServices.size() > 0) {
            this.genProperties(context, restServices, deployingRUIHandlers, requestor);
        }
    }

    private void genProperties(DeploymentContext context, Set<Part> services, boolean setGlobalProperty, DeploymentResultMessageRequestor requestor) {
        block19: {
            IFile file = null;
            try {
                if (!context.getTargetProject().hasNature("org.eclipse.jdt.core.javanature")) break block19;
                IJavaProject javaProject = JavaCore.create((IProject)context.getTargetProject());
                IPath srcFolder = null;
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        srcFolder = entry.getPath();
                        break;
                    }
                    ++n2;
                }
                if (srcFolder == null) break block19;
                StringBuilder contents = new StringBuilder(100);
                Properties props = new Properties();
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(srcFolder.append(RUNUNIT_PROPERTIES));
                if (file.exists()) {
                    BufferedInputStream bis = null;
                    try {
                        bis = new BufferedInputStream(file.getContents(true));
                        props.load(bis);
                        contents.append(Util.getFileContents((IFile)file));
                        if (contents.charAt(contents.length() - 1) != '\n') {
                            contents.append('\n');
                        }
                    }
                    catch (Throwable throwable) {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                String ddName = context.getDeploymentDesc().getEGLDDFileName().toLowerCase();
                boolean changed = false;
                if (setGlobalProperty && this.appendPropertyIfNecessary("egl.application.property.file", ddName, props, contents)) {
                    changed = true;
                }
                for (Part part : services) {
                    String id = part.getCaseSensitiveName();
                    String pkg = part.getCaseSensitivePackageName();
                    String generatedName = pkg == null || pkg.length() == 0 ? JavaAliaser.getAlias((String)id) : String.valueOf(JavaAliaser.packageNameAlias((String)pkg)) + '.' + JavaAliaser.getAlias((String)id);
                    String key = "egl.application.property.file." + generatedName;
                    if (!this.appendPropertyIfNecessary(key, ddName, props, contents)) continue;
                    changed = true;
                }
                if (changed) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(contents.toString().getBytes());
                    if (file.exists()) {
                        file.setContents((InputStream)bais, true, false, null);
                    } else {
                        file.create((InputStream)bais, true, null);
                    }
                    requestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8319", null, (String[])new String[]{file.getProjectRelativePath().toPortableString()}));
                }
            }
            catch (Exception e) {
                requestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8318", null, (String[])new String[]{file == null ? RUNUNIT_PROPERTIES : file.getProjectRelativePath().toPortableString()}));
                requestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8306", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
            }
        }
    }

    private boolean appendPropertyIfNecessary(String key, String value, Properties prevProps, StringBuilder buf) {
        String prevValue = prevProps.getProperty(key);
        if (prevValue == null || !value.equals(prevValue.trim())) {
            buf.append(key);
            buf.append('=');
            buf.append(value);
            buf.append('\n');
            return true;
        }
        return false;
    }

    private Set<Part> findRESTServices(DeploymentContext context, DeploymentResultMessageRequestor requestor) {
        HashSet<Part> services = new HashSet<Part>();
        List restServices = context.getDeploymentDesc().getRestservices();
        for (Restservice rest : restServices) {
            if (!rest.isEnableGeneration()) continue;
            try {
                Part part = context.findPart(rest.getImplementation());
                services.add(part);
            }
            catch (PartNotFoundException e) {
                requestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8305", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
            }
        }
        return services;
    }
}

