/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;

public class BrowserManager {
    public static final byte IE = 1;
    public static final byte WEBKIT = 2;
    public static final byte XULRUNNER = 4;
    public static final int SWT_WEBKIT = 65536;
    public boolean ECLIPSE_36;
    private byte BROWSERS = 0;
    private Integer defaultBrowser;
    private static BrowserManager INSTANCE;

    private BrowserManager() {
    }

    public static BrowserManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BrowserManager();
            INSTANCE.initializeBrowser();
        }
        return INSTANCE;
    }

    private void initializeBrowser() {
        try {
            Version version = Platform.getBundle((String)"org.eclipse.core.runtime").getVersion();
            boolean bl = this.ECLIPSE_36 = version.getMajor() == 3 && version.getMinor() == 6;
            if (!this.ECLIPSE_36) {
                Browser b = new Browser((Composite)Display.getCurrent().getShells()[0], 65536);
                this.BROWSERS = (byte)(this.BROWSERS | 2);
                b.dispose();
            }
        }
        catch (Throwable throwable) {}
        try {
            Browser b = new Browser((Composite)Display.getCurrent().getShells()[0], 32768);
            this.BROWSERS = (byte)(this.BROWSERS | 4);
            b.dispose();
        }
        catch (Throwable throwable) {}
    }

    public Browser createBrowser(Composite compositeParent) {
        switch (EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.RenderEngine")) {
            case 1: {
                return this.createWebKit(compositeParent);
            }
            case 2: {
                return this.createXULRunner(compositeParent);
            }
        }
        return this.createNONE(compositeParent);
    }

    private Browser createWebKit(Composite compositeParent) {
        try {
            Browser browser = new Browser(compositeParent, 65536);
            BrowserManager.initializeBrowser(compositeParent.getDisplay(), browser, 65536);
            return browser;
        }
        catch (SWTError ex) {
            Activator.log(ex);
            this.showOutOfResourcesMessage(Messages.NL_WEBKIT_Out_of_resources_message);
            return null;
        }
    }

    private Browser createXULRunner(Composite compositeParent) {
        try {
            Browser browser = new Browser(compositeParent, 32768);
            BrowserManager.initializeBrowser(compositeParent.getDisplay(), browser, 32768);
            return browser;
        }
        catch (SWTError ex) {
            Activator.log(ex);
            this.showOutOfResourcesMessage(Messages.NL_XULRunner_Out_of_resources_message);
            return null;
        }
    }

    private Browser createNONE(Composite compositeParent) {
        try {
            Browser browser = new Browser(compositeParent, 0);
            BrowserManager.initializeBrowser(compositeParent.getDisplay(), browser, 0);
            return browser;
        }
        catch (SWTError ex) {
            Activator.log(ex);
            this.showOutOfResourcesMessage(Messages.NL_IE_Out_of_resources_message);
            return null;
        }
    }

    private static void initializeBrowser(final Display display, Browser browser, final int style) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (!event.required) {
                    return;
                }
                Shell shell = new Shell(display);
                shell.setLayout((Layout)new FillLayout());
                Browser browser = new Browser((Composite)shell, style);
                BrowserManager.initializeBrowser(display, browser, style);
                event.browser = browser;
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        if (style == 32768) {
            browser.execute("try { var ioService = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService2); ioService.offline = false; } catch ( e ) {}");
        }
    }

    public void showOutOfResourcesMessage(String message) {
        String[] straButtons = new String[]{IDialogConstants.OK_LABEL};
        MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), Messages.NL_EGL_Rich_UI_Editor, null, message, 4, straButtons, 0);
        dialog.open();
    }

    public int getDefaultRenderEngine() {
        if (this.defaultBrowser == null) {
            if (Platform.getOS().equals("win32")) {
                this.defaultBrowser = 3;
                if (!Platform.getOSArch().equals("x86_64")) {
                    if ((this.BROWSERS & 2) != 0) {
                        this.defaultBrowser = 1;
                    } else if ((this.BROWSERS & 4) != 0) {
                        this.defaultBrowser = 2;
                    }
                }
            } else {
                this.defaultBrowser = (this.BROWSERS & 4) != 0 ? Integer.valueOf(2) : Integer.valueOf(0);
            }
        }
        return this.defaultBrowser;
    }

    public void displayBrowserInfo(Browser browser) {
        Object agent = null;
        Shell shell = null;
        if (browser != null) {
            agent = browser.evaluate("return navigator.userAgent;");
            shell = browser.getDisplay().getActiveShell();
        }
        if (!(agent instanceof String)) {
            agent = Messages.NL_User_Agent_Error_Retrieving;
        }
        if (shell == null) {
            shell = Display.getDefault().getActiveShell();
        }
        new MessageDialog(shell, Messages.NL_User_Agent_Title, null, (String)agent, 0, new String[]{IDialogConstants.OK_LABEL}, 0).open();
    }
}

