/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class BindingEGLConfiguration
extends BindingBaseConfiguration {
    private String fAlias = "";
    protected int fSelectedCommTypeBtnIndex;
    private EGLDeploymentRoot fDeploymentRoot;
    private IFile fEGLDDFile = null;

    public BindingEGLConfiguration() {
        this.setDefaultAttributes();
    }

    public BindingEGLConfiguration(EGLDeploymentRoot root, IProject proj) {
        this.init(root, proj);
    }

    public void init(EGLDeploymentRoot root, IProject proj) {
        this.fDeploymentRoot = root;
        this.fProj = proj;
        this.setDefaultAttributes();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        IPart servicePart = null;
        IEGLFile serviceFile = null;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IFile) {
            IEGLElement eglElem = EGLCore.create((IFile)((IFile)selectedElement));
            if (eglElem instanceof IEGLFile) {
                serviceFile = (IEGLFile)eglElem;
            }
        } else if (selectedElement instanceof IEGLFile) {
            serviceFile = (IEGLFile)selectedElement;
        }
        if (serviceFile != null) {
            String eglFileName = serviceFile.getElementName();
            int dot = eglFileName.indexOf(46);
            String partSimpleName = eglFileName.substring(0, dot);
            servicePart = serviceFile.getPart(partSimpleName);
        }
        if (selectedElement instanceof IPart) {
            servicePart = (IPart)selectedElement;
        }
        if (servicePart != null) {
            this.setBindingName(servicePart.getElementName());
            this.setEGLServiceOrInterface(servicePart.getFullyQualifiedName());
            this.setAlias("");
            this.fProj = servicePart.getEGLProject().getProject();
        }
    }

    protected void setDefaultAttributes() {
        this.fSelectedCommTypeBtnIndex = 1;
    }

    public String getAlias() {
        return this.fAlias;
    }

    public void setAlias(String alias) {
        this.fAlias = alias;
    }

    public int getSelectedCommTypeBtnIndex() {
        return this.fSelectedCommTypeBtnIndex;
    }

    public void setSelectedCommTypeBtnIndex(int index) {
        this.fSelectedCommTypeBtnIndex = index;
    }

    public Object executeAddBinding(Bindings abindings) {
        if (this.fEGLDDFile != null && !this.fEGLDDFile.exists()) {
            String encodingName = EGLBasePlugin.getPlugin().getPreferenceStore().getString("outputCodeset");
            EGLDDRootHelper.createNewEGLDDFile(this.fEGLDDFile, encodingName);
        }
        this.fDeploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(this.fEGLDDFile, false);
        if (this.fDeploymentRoot != null) {
            try {
                Binding existingEGLBinding;
                Deployment deployment = this.fDeploymentRoot.getDeployment();
                Bindings bindings = deployment.getBindings();
                if (bindings == null) {
                    bindings = DeploymentFactory.eINSTANCE.createBindings();
                    deployment.setBindings(bindings);
                }
                if (this.isOverwrite() && (existingEGLBinding = EGLDDRootHelper.getBindingByName(this.fDeploymentRoot, this.getBindingName())) != null) {
                    bindings.getBinding().remove((Object)existingEGLBinding);
                }
                if (!EGLDDRootHelper.isWorkingModelSharedByUserClients(this.fEGLDDFile)) {
                    EGLDDRootHelper.saveEGLDDFile(this.fEGLDDFile, this.fDeploymentRoot);
                }
            }
            finally {
                if (this.fEGLDDFile != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(this.fEGLDDFile, false);
                }
            }
        }
        return null;
    }

    public EGLDeploymentRoot getEGLDeploymentRoot() {
        return this.fDeploymentRoot;
    }

    public void setEGLDeploymentDescriptor(IFile eglddFile, EGLDeploymentRoot deploymentRoot) {
        this.fEGLDDFile = eglddFile;
        this.fDeploymentRoot = deploymentRoot;
    }

    @Override
    public String getFileExtension() {
        return "egldd";
    }

    protected String getValidBindingName(String bindingName) {
        int length = bindingName.length();
        StringBuilder validName = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            if (Character.isJavaIdentifierPart(bindingName.charAt(i))) {
                validName.append(bindingName.charAt(i));
            }
            ++i;
        }
        if (validName.length() > 0) {
            bindingName = validName.toString();
        }
        Binding binding = EGLDDRootHelper.getBindingByName(this.getEGLDeploymentRoot(), bindingName);
        int incrementIndex = 1;
        while (binding != null) {
            binding = EGLDDRootHelper.getBindingByName(this.getEGLDeploymentRoot(), String.valueOf(bindingName) + incrementIndex);
            ++incrementIndex;
        }
        if (incrementIndex > 1) {
            bindingName = String.valueOf(bindingName) + --incrementIndex;
        }
        return bindingName;
    }
}

