/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.SearchUtil;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class GotoMarkerAction
extends Action {
    public void run() {
        ISearchResultView view = SearchUI.getSearchResultView();
        Object element = this.getSingleElement(view.getSelection());
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
            this.show(entry.getSelectedMarker());
        }
    }

    private Object getSingleElement(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    private void show(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource == null || !resource.exists()) {
            return;
        }
        IWorkbenchPage wbPage = EDTUIPlugin.getActivePage();
        IEGLElement eglElement = SearchUtil.getEGLElement(marker);
        if (eglElement != null && eglElement.getElementType() == 4) {
            this.gotoPackagesView(eglElement, wbPage);
        } else {
            this.showWithoutReuse(marker, eglElement, wbPage);
        }
    }

    private void showWithoutReuse(IMarker marker, IEGLElement eglElement, IWorkbenchPage wbPage) {
        IEditorPart editor = null;
        try {
            IEGLElement objectToOpen = eglElement;
            if (objectToOpen == null) {
                objectToOpen = marker.getResource();
            }
            editor = EditorUtility.openInEditor(objectToOpen, false);
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)EDTUIPlugin.getActiveWorkbenchShell(), (String)EGLSearchMessages.Search_Error_openEditor_title, (String)EGLSearchMessages.Search_Error_openEditor_message);
        }
        if (editor != null) {
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
    }

    private void gotoPackagesView(IEGLElement eglElement, IWorkbenchPage wbPage) {
        try {
            IViewPart view = wbPage.showView("org.eclipse.edt.ide.ui.PackageExplorer");
            if (view instanceof IPackagesViewPart) {
                ((IPackagesViewPart)view).selectAndReveal((Object)eglElement);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)EDTUIPlugin.getActiveWorkbenchShell(), (String)EGLSearchMessages.Search_Error_openEditor_title, (String)EGLSearchMessages.Search_Error_openEditor_message);
        }
    }
}

