/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementUtility;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;

public abstract class EGLSQLStatementFactory {
    List errorMessages;
    protected Member sqlRecordData;
    protected Type sqlRecordTypeBinding;
    List<Field> structureItemBindings;
    protected int numSQLDataItems;
    protected String ioObjectName;
    String[] itemNames;
    String[] columnNames;
    String[] tableNames;
    String[] tableLabels;
    List<Field> keyItems;
    protected String[][] keyItemAndColumnNames;
    String sqlStatement;
    boolean useRecordKeys;

    public EGLSQLStatementFactory(Member recordData, String ioObjectName) {
        this.sqlRecordData = recordData;
        this.ioObjectName = ioObjectName;
        this.errorMessages = new ArrayList();
        this.useRecordKeys = true;
    }

    public String buildDefaultSQLStatement() {
        return null;
    }

    public String getEglUsingClause() {
        return null;
    }

    public List getErrorMessages() {
        return this.errorMessages;
    }

    protected boolean setupSQLInfo() {
        boolean isValidIoObject = true;
        if (!SQLIOStatementUtility.isEntityRecord(this.getSQLRecordTypeBinding()) && !SQLIOStatementUtility.isBasicRecord(this.getSQLRecordTypeBinding())) {
            isValidIoObject = false;
        } else {
            List dataBindings;
            List list = dataBindings = this.getSQLRecordTypeBinding() instanceof LogicAndDataPart ? ((LogicAndDataPart)this.getSQLRecordTypeBinding()).getFields() : null;
            if (dataBindings == null) {
                this.numSQLDataItems = 0;
                this.structureItemBindings = new ArrayList<Field>(this.numSQLDataItems);
            } else {
                this.structureItemBindings = new ArrayList<Field>(dataBindings.size());
                int i = 0;
                while (i < dataBindings.size()) {
                    Field itemBinding = (Field)dataBindings.get(i);
                    if (this.shouldKeep(itemBinding)) {
                        this.structureItemBindings.add(itemBinding);
                        ++this.numSQLDataItems;
                    }
                    ++i;
                }
            }
            if (SQLIOStatementUtility.isEntityRecord(this.getSQLRecordTypeBinding()) && !this.isIoObjectValid()) {
                isValidIoObject = false;
            }
        }
        if (!isValidIoObject) {
            this.errorMessages.add(0, this.getCouldNotBuildDefaultMessage());
            return false;
        }
        this.setupItemColumnAndKeyInfo();
        this.setupTableInfo();
        return true;
    }

    private boolean shouldKeep(Field dataBinding) {
        if (dataBinding == null) {
            return false;
        }
        Type typeBinding = dataBinding.getType();
        if (!TypeUtils.isPrimitive((Type)typeBinding)) {
            return false;
        }
        return TypeUtils.Type_ANY.equals(typeBinding) == false;
    }

    protected void setupTableInfo() {
        ArrayList<String> sqlTables = new ArrayList<String>();
        ArrayList<String> sqlTableLables = new ArrayList<String>();
        int tableIndex = 1;
        boolean haveTableAnnotation = false;
        if (SQLIOStatementUtility.isEntityRecord(this.getSQLRecordTypeBinding()) || SQLIOStatementUtility.isBasicRecord(this.getSQLRecordTypeBinding())) {
            ArrayList<Object> declarers = new ArrayList<Object>();
            declarers.add(this.getSQLRecordTypeBinding());
            Part declaringPart = BindingUtil.getDeclaringPart((Member)this.sqlRecordData);
            if (declaringPart instanceof Record && "get".toUpperCase().equals(this.getIOType())) {
                declarers.add(declaringPart);
            }
            for (Type type : declarers) {
                String tableName;
                Annotation annotation = type.getAnnotation("eglx.persistence.sql.Table");
                haveTableAnnotation = false;
                if (annotation != null && (tableName = (String)annotation.getValue("name")) != null) {
                    haveTableAnnotation = true;
                    sqlTables.add(tableName);
                    sqlTableLables.add("t" + tableIndex);
                    ++tableIndex;
                }
                if (haveTableAnnotation) continue;
                sqlTables.add(BindingUtil.getShortTypeString((Type)type, (boolean)false));
                sqlTableLables.add("t" + tableIndex);
                ++tableIndex;
            }
        }
        this.tableNames = sqlTables.toArray(new String[0]);
        this.tableLabels = sqlTableLables.toArray(new String[0]);
    }

    protected Problem getCouldNotBuildDefaultMessage() {
        return new Problem(0, 0, 2, 4515, new String[]{this.getSQLStatementType(), this.getIOType(), this.ioObjectName});
    }

    protected void setupItemColumnAndKeyInfo() {
    }

    protected void setupForSQLInsertStatement() {
        String[] items = new String[this.numSQLDataItems];
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnly = 0;
        if (this.structureItemBindings != null) {
            for (Field itemBinding : this.structureItemBindings) {
                String itemName = itemBinding.getName();
                String columnName = this.getColumnName(itemBinding);
                boolean isReadOnly = this.getIsReadOnly(itemBinding);
                if (isReadOnly) continue;
                items[numNonReadOnly] = itemName;
                columns[numNonReadOnly] = columnName;
                ++numNonReadOnly;
            }
        }
        if (numNonReadOnly != 0) {
            this.itemNames = new String[numNonReadOnly];
            this.columnNames = new String[numNonReadOnly];
            int i = 0;
            while (i < numNonReadOnly) {
                this.itemNames[i] = items[i];
                this.columnNames[i] = columns[i];
                ++i;
            }
        }
    }

    public void setupForSQLUpdateStatement() {
        String[] items = new String[this.numSQLDataItems];
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnlyAndKeys = 0;
        int numKeys = 0;
        if (this.keyItemAndColumnNames == null) {
            this.keyItemAndColumnNames = this.getKeyItems() != null ? new String[this.getKeyItems().size()][2] : new String[0][0];
        } else {
            this.useRecordKeys = false;
        }
        if (this.structureItemBindings != null) {
            int i = 0;
            while (i < this.numSQLDataItems) {
                Field itemBinding = this.structureItemBindings.get(i);
                String itemName = itemBinding.getName();
                String columnName = this.getColumnName(itemBinding);
                boolean isUpdateable = this.getIsUpdateable(itemBinding);
                if (isUpdateable && !this.isRecordKeyItem(itemBinding)) {
                    items[numNonReadOnlyAndKeys] = itemName;
                    columns[numNonReadOnlyAndKeys] = columnName;
                    ++numNonReadOnlyAndKeys;
                }
                if (this.useRecordKeys && this.isRecordKeyItem(itemBinding)) {
                    this.keyItemAndColumnNames[numKeys][0] = itemName;
                    this.keyItemAndColumnNames[numKeys][1] = columnName;
                    ++numKeys;
                }
                ++i;
            }
        }
        if (numNonReadOnlyAndKeys != 0) {
            this.itemNames = new String[numNonReadOnlyAndKeys];
            this.columnNames = new String[numNonReadOnlyAndKeys];
            int i = 0;
            while (i < numNonReadOnlyAndKeys) {
                this.itemNames[i] = items[i];
                this.columnNames[i] = columns[i];
                ++i;
            }
        }
        if (this.useRecordKeys && numKeys == 0 && this.getKeyItems().size() > 0) {
            this.keyItemAndColumnNames = new String[0][0];
        }
    }

    protected boolean validateSQLRecordNotJoinAndContainsReadWriteColumns() {
        boolean isValid = this.validateSQLRecordNotJoin();
        if (!this.validateSQLRecordContainsReadWriteColumns()) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateSQLRecordContainsReadWriteColumns() {
        if (!this.hasReadWriteColumns()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4531, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    protected boolean hasReadWriteColumns() {
        if (this.getSQLRecordTypeBinding() != null) {
            if (this.structureItemBindings != null && this.structureItemBindings.size() > 0) {
                for (Field field : this.structureItemBindings) {
                    if (this.getIsReadOnly(field)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn() {
        boolean isValid = this.validateSQLRecordNotJoin();
        if (!this.validateSQLRecordContainsOneNonReadOnlyOrNonKeyColumn()) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateSQLRecordContainsOneNonReadOnlyOrNonKeyColumn() {
        if (this.containsOnlyKeyOrReadOnlyColumns()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4533, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    protected boolean containsOnlyKeyOrReadOnlyColumns() {
        if (this.getSQLRecordTypeBinding() != null) {
            return SQLIOStatementUtility.containsOnlyKeyOrReadOnlyColumns(this.getSQLRecordTypeBinding(), this.getKeyItems());
        }
        return false;
    }

    protected Type getSQLRecordTypeBinding() {
        if (this.sqlRecordTypeBinding == null && this.sqlRecordData != null) {
            this.sqlRecordTypeBinding = this.sqlRecordData.getType();
            while (this.sqlRecordTypeBinding instanceof ArrayType) {
                this.sqlRecordTypeBinding = ((ArrayType)this.sqlRecordTypeBinding).getElementType();
            }
        }
        return this.sqlRecordTypeBinding;
    }

    protected boolean validateSQLRecordNotJoin() {
        if (this.isSQLRecordDefinedWithMultipleTables()) {
            this.errorMessages.add(new Problem(0, 0, 2, 4532, new String[]{this.ioObjectName, this.getIOType()}));
            return false;
        }
        return true;
    }

    public List<Field> getKeyItems() {
        if (this.keyItems == null) {
            this.keyItems = new ArrayList<Field>();
            if (this.getSQLRecordTypeBinding() instanceof LogicAndDataPart) {
                List dataBindings = ((LogicAndDataPart)this.getSQLRecordTypeBinding()).getFields();
                for (Field dataBinding : dataBindings) {
                    if (!Utils.isKeyField((Field)dataBinding) || dataBinding.getType() == null) continue;
                    this.keyItems.add(dataBinding);
                }
            }
        }
        return this.keyItems;
    }

    private int getTableIndex(String tableName) {
        int index = -1;
        if (this.tableNames != null && tableName != null) {
            int i = 0;
            while (i < this.tableNames.length) {
                if (tableName.equals(this.tableNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    protected String getDefaultSelectConditions() {
        String defaultSelectConditions = null;
        if ((SQLIOStatementUtility.isEntityRecord(this.getSQLRecordTypeBinding()) || SQLIOStatementUtility.isBasicRecord(this.getSQLRecordTypeBinding())) && this.tableNames.length > 0) {
            Map<Type, String> foreignKeys = SQLIOStatementUtility.getForeignKeys(this.sqlRecordData, this.getSQLRecordTypeBinding());
            String masterTableName = null;
            String slaveTableName = SQLIOStatementUtility.getTableName(this.sqlRecordData.getType());
            int slaveIndex = this.getTableIndex(slaveTableName);
            if (slaveTableName != null && slaveIndex != -1 && foreignKeys != null) {
                for (Type masterTable : foreignKeys.keySet()) {
                    int tableIndex;
                    masterTableName = SQLIOStatementUtility.getTableName(masterTable);
                    if (masterTableName == null || (tableIndex = this.getTableIndex(masterTableName)) == -1) continue;
                    defaultSelectConditions = String.valueOf(this.tableLabels[slaveIndex]) + "." + foreignKeys.get(masterTable) + "=" + this.tableLabels[tableIndex] + "." + SQLIOStatementUtility.getIdColumnName(masterTable) + " " + "and" + " " + this.tableLabels[tableIndex] + "." + SQLIOStatementUtility.getIdColumnName(masterTable) + "=" + "?";
                }
            }
        }
        if (defaultSelectConditions == null) {
            return null;
        }
        if ((defaultSelectConditions = defaultSelectConditions.trim()).length() == 0) {
            return null;
        }
        defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, '\r');
        defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, '\n');
        if ((defaultSelectConditions = this.trimLeadingChar(defaultSelectConditions, ' ')).trim().length() == 0) {
            return null;
        }
        return defaultSelectConditions;
    }

    public String trimLeadingChar(String s, char charToTrim) {
        char[] c = s.toCharArray();
        int length = c.length;
        int start = 0;
        while (start < length && c[start] == charToTrim) {
            ++start;
        }
        return start > 0 ? s.substring(start, length) : s;
    }

    protected boolean isIoObjectValid() {
        return true;
    }

    protected boolean isRecordKeyItem(Field data) {
        return this.getKeyItems().contains(data);
    }

    protected boolean isSQLRecordDefinedWithMultipleTables() {
        return this.getSQLRecordTypeBinding() instanceof EGLClass && Utils.getTableName((EGLClass)((EGLClass)this.getSQLRecordTypeBinding())).indexOf(44) != -1;
    }

    protected String getColumnName(Field itemBinding) {
        return Utils.getColumnName((Field)itemBinding);
    }

    protected boolean getIsReadOnly(Field itemBinding) {
        return SQLIOStatementUtility.getIsReadOnly(itemBinding);
    }

    protected boolean getIsUpdateable(Field itemBinding) {
        return SQLIOStatementUtility.getIsUpdateable(itemBinding);
    }

    public String getWhereCurrentOfClause() {
        return "where current of resultSetID";
    }

    public abstract String getIOType();

    public abstract String getSQLStatementType();
}

