/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix;

import java.util.Comparator;
import org.eclipse.edt.ide.ui.editor.IEGLCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public final class CompletionProposalComparator
implements Comparator {
    private boolean fOrderAlphabetically = false;

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this.fOrderAlphabetically = orderAlphabetically;
    }

    public int compare(Object o1, Object o2) {
        ICompletionProposal p1 = (ICompletionProposal)o1;
        ICompletionProposal p2 = (ICompletionProposal)o2;
        if (!this.fOrderAlphabetically) {
            int r1 = this.getRelevance(p1);
            int r2 = this.getRelevance(p2);
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
        }
        return this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
    }

    private String getSortKey(ICompletionProposal p) {
        return p.getDisplayString();
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof IEGLCompletionProposal) {
            IEGLCompletionProposal ecp = (IEGLCompletionProposal)obj;
            return ecp.getRelevance();
        }
        return 0;
    }
}

