/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.editor.AccumulatingDynamicProblemRequestor;
import org.eclipse.edt.ide.ui.internal.editor.AccumulatingSyntaxProblemRequestor;
import org.eclipse.edt.ide.ui.internal.editor.AccumulatingTopLevelProblemRequestor;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLMarkerAnnotationModel;
import org.eclipse.edt.ide.ui.internal.editor.ReportedProblem;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProblemReconciler
implements IReconciler {
    private IEGLDocument fDocument;
    private Listener fModelListener;
    private IPropertyChangeListener fPropertyListener;
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private IPartListener fPartListener;
    private IResourceChangeListener fResourceChangeListener;
    private BackgroundThread fThread;
    private int fDelay = 500;
    private DocumentProvider fProvider;
    private EGLMarkerAnnotationModel fModel;
    private EGLReconcilingStrategy fStrategy = new EGLReconcilingStrategy();
    private boolean fIsEditorActive;

    public ProblemReconciler(ITextEditor editor) {
        this.fEditor = editor;
        this.fProvider = (DocumentProvider)this.fEditor.getDocumentProvider();
        this.fModel = (EGLMarkerAnnotationModel)this.fProvider.getAnnotationModel(this.fEditor.getEditorInput());
        if (this.fModel != null) {
            boolean enable = this.fModel.shouldEnableDynamicProblems();
            this.fModel.setIsHandlingDynamicProblems(enable);
        }
    }

    protected void forceReconciling(boolean forceReset) {
        if (this.fDocument != null) {
            this.startReconciling(forceReset);
        }
    }

    protected synchronized void startReconciling(boolean forceReset) {
        if (this.fThread == null) {
            return;
        }
        if (!this.fThread.isAlive()) {
            try {
                this.fThread.start();
                if (forceReset) {
                    this.fThread.reset();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        } else {
            this.fThread.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ITextViewer textViewer) {
        this.fViewer = textViewer;
        ProblemReconciler problemReconciler = this;
        synchronized (problemReconciler) {
            if (this.fThread != null) {
                return;
            }
            this.fThread = new BackgroundThread(this.getClass().getName());
        }
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fModelListener = new Listener();
        this.fViewer.addTextInputListener((ITextInputListener)this.fModelListener);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace workspace = EDTUIPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.fResourceChangeListener);
        this.fPropertyListener = new EGLPropertyChangeListener();
        EDTUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        IWorkbenchPartSite site = this.fEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        this.fViewer.removeTextInputListener((ITextInputListener)this.fModelListener);
        this.fModelListener = null;
        IWorkspace workspace = EDTUIPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.fResourceChangeListener);
        this.fResourceChangeListener = null;
        EDTUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        this.fPropertyListener = null;
        ProblemReconciler problemReconciler = this;
        synchronized (problemReconciler) {
            BackgroundThread bt = this.fThread;
            this.fThread = null;
            bt.cancel();
        }
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean state) {
        this.fIsEditorActive = state;
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    private class BackgroundThread
    extends Thread {
        private boolean fCanceled;
        private boolean fReset;
        private boolean fIsDirty;

        public BackgroundThread(String name) {
            super(name);
            this.fCanceled = false;
            this.fReset = false;
            this.fIsDirty = false;
            this.setPriority(1);
            this.setDaemon(true);
        }

        public synchronized boolean isDirty() {
            return this.fIsDirty;
        }

        public void cancel() {
            this.fCanceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.fIsDirty = true;
                this.fReset = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.fCanceled) {
                BackgroundThread backgroundThread = this;
                synchronized (backgroundThread) {
                    try {
                        this.wait(ProblemReconciler.this.fDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fCanceled) break;
                if (!this.isDirty()) continue;
                backgroundThread = this;
                synchronized (backgroundThread) {
                    if (this.fReset) {
                        this.fReset = false;
                        continue;
                    }
                }
                ProblemReconciler.this.fStrategy.reconcile();
                backgroundThread = this;
                synchronized (backgroundThread) {
                    if (!this.fReset) {
                        this.fIsDirty = false;
                    }
                }
            }
        }
    }

    private class EGLPropertyChangeListener
    implements IPropertyChangeListener {
        private EGLPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("handleDynamicProblems".equals(event.getProperty())) {
                boolean enable = ProblemReconciler.this.fModel.shouldEnableDynamicProblems();
                ProblemReconciler.this.fModel.setIsHandlingDynamicProblems(enable);
                if (enable && ProblemReconciler.this.isEditorActive()) {
                    ProblemReconciler.this.forceReconciling(false);
                }
            }
        }
    }

    private class EGLReconcilingStrategy {
        private EGLReconcilingStrategy() {
        }

        protected void reconcile() {
            if (ProblemReconciler.this.fDocument != null && ProblemReconciler.this.fModel != null && ProblemReconciler.this.fModel.isHandlingDynamicProblems()) {
                IFile file = ((IFileEditorInput)ProblemReconciler.this.fEditor.getEditorInput()).getFile();
                IProject proj = file.getProject();
                IWorkingCopy[] currRegedWCs = EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory());
                IEGLElement eglFile = EGLCore.create((IFile)file);
                if (eglFile instanceof IEGLFile) {
                    IPackageFragment packageFragment = (IPackageFragment)eglFile.getAncestor(4);
                    String pkgName = packageFragment.isDefaultPackage() ? "" : packageFragment.getElementName();
                    ReconcilerProblemRequestorFactory problemFactory = new ReconcilerProblemRequestorFactory(file);
                    IDocument document = ProblemReconciler.this.fProvider.getDocument(ProblemReconciler.this.fEditor.getEditorInput());
                    if (document != null) {
                        WorkingCopyCompiler.getInstance().compileAllParts(proj, pkgName, file, currRegedWCs, new IWorkingCopyCompileRequestor(){

                            public void acceptResult(WorkingCopyCompilationResult result) {
                            }
                        }, (IProblemRequestorFactory)problemFactory);
                        ArrayList reportedProblems = new ArrayList();
                        List errors = problemFactory.problemRequestor.getProblems();
                        List syntaxErrors = problemFactory.syntaxErrorRequestor.getProblems();
                        String filePath = file.getFullPath().toOSString();
                        IEditorInput editorInput = ProblemReconciler.this.fEditor.getEditorInput();
                        if (editorInput == null) {
                            System.out.println("Null editor input");
                        }
                        this.buildProblemList(document, filePath, reportedProblems, syntaxErrors, "SYN");
                        this.buildProblemList(document, filePath, reportedProblems, errors, "VAL");
                        ProblemReconciler.this.fModel.reportProblems(reportedProblems);
                    }
                }
            }
        }

        private void buildProblemList(IDocument document, String filePath, List reportedProblems, List errors, String errorMsg) {
            for (Problem problem : errors) {
                reportedProblems.add(new ReportedProblem(document, filePath, errorMsg, problem));
            }
        }
    }

    private class Listener
    implements ITextInputListener,
    IEGLModelChangeListener {
        private Listener() {
        }

        public void modelChanged() {
            ProblemReconciler.this.startReconciling(false);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == ProblemReconciler.this.fDocument) {
                if (ProblemReconciler.this.fDocument != null) {
                    ProblemReconciler.this.fDocument.removeModelChangeListener((IEGLModelChangeListener)this);
                }
                ProblemReconciler.this.fDocument = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput instanceof IEGLDocument) {
                ProblemReconciler.this.fDocument = (IEGLDocument)newInput;
            }
            if (ProblemReconciler.this.fDocument == null) {
                return;
            }
            ProblemReconciler.this.fDocument.addModelChangeListener((IEGLModelChangeListener)this);
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == ProblemReconciler.this.fEditor) {
                ProblemReconciler.this.forceReconciling(true);
                ProblemReconciler.this.setEditorActive(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            ProblemReconciler.this.setEditorActive(false);
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class ReconcilerProblemRequestorFactory
    implements IProblemRequestorFactory {
        private AccumulatingSyntaxProblemRequestor syntaxErrorRequestor;
        private AccumulatingDynamicProblemRequestor problemRequestor;
        private AccumulatingTopLevelProblemRequestor topLevelProblemRequestor;
        private IFile file;

        private ReconcilerProblemRequestorFactory(IFile file) {
            this.file = file;
            try {
                this.syntaxErrorRequestor = new AccumulatingSyntaxProblemRequestor(Util.getFileContents((IFile)file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.problemRequestor = new AccumulatingDynamicProblemRequestor();
            this.topLevelProblemRequestor = new AccumulatingTopLevelProblemRequestor((IProblemRequestor)this.problemRequestor);
        }

        public IProblemRequestor getContainerContextTopLevelProblemRequestor(IFile file, String functionPartName, String containerContextName, IPath containerContextPath, boolean containerContextDependent) {
            if (!this.file.equals((Object)file)) {
                return org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor.getInstance();
            }
            this.topLevelProblemRequestor.setContainerContextDependent(containerContextDependent);
            this.topLevelProblemRequestor.setReportContextErrors(true);
            ((AccumulatingDynamicProblemRequestor)this.topLevelProblemRequestor.getRequestor()).setContainerContextName(containerContextName);
            return this.topLevelProblemRequestor;
        }

        public IProblemRequestor getGenericTopLevelFunctionProblemRequestor(IFile file, String partName, boolean containerContextDependent) {
            this.topLevelProblemRequestor.setContainerContextDependent(containerContextDependent);
            this.topLevelProblemRequestor.setReportContextErrors(false);
            return this.topLevelProblemRequestor;
        }

        public IProblemRequestor getProblemRequestor(IFile file, String partName) {
            this.problemRequestor.setContainerContextName(partName);
            return this.problemRequestor;
        }

        public ISyntaxErrorRequestor getSyntaxErrorRequestor(IFile file) {
            if (this.file.equals((Object)file)) {
                return this.syntaxErrorRequestor;
            }
            return new NullProblemRequestor();
        }

        public IProblemRequestor getFileProblemRequestor(IFile file) {
            if (this.file.equals((Object)file)) {
                return this.problemRequestor;
            }
            return org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor.getInstance();
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        private IResource getResource() {
            IEditorInput input = ProblemReconciler.this.fEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IMarkerDelta[] deltas;
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            IResource resource = this.getResource();
            if (delta != null && resource != null && (child = delta.findMember(resource.getFullPath())) != null && (deltas = child.getMarkerDeltas()).length > 0) {
                ProblemReconciler.this.forceReconciling(false);
            }
        }
    }
}

