/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.internal.search.AllPartsCache;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.Strings;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.util.PartInfoLabelProvider;
import org.eclipse.edt.ide.ui.internal.util.StringMatcher;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class PartSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IEGLSearchScope fScope;
    private int fElementKinds;
    private String fSubType;

    public PartSelectionDialog(Shell parent, IRunnableContext context, int elementKinds, String subType, IEGLSearchScope scope) {
        super(parent, (ILabelProvider)new PartInfoLabelProvider(16), (ILabelProvider)new PartInfoLabelProvider(40));
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKinds = elementKinds;
        this.fSubType = subType;
        this.setUpperListLabel(UINlsStrings.OpenPartDialog_UpperLabel);
        this.setLowerListLabel(UINlsStrings.OpenPartDialog_LowerLabel);
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        this.fFilteredList.setComparator((Comparator)new StringComparator());
        return list;
    }

    public int open() {
        ArrayList typeList = new ArrayList();
        if (this.addParts(typeList, this.fScope, this.fElementKinds, this.fSubType) == 1) {
            return 1;
        }
        if (typeList.isEmpty()) {
            String title = this.getNoPartsTitle();
            String message = this.getNoPartsMessage();
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        Object[] typeRefs = typeList.toArray(new PartInfo[typeList.size()]);
        this.setElements(typeRefs);
        return super.open();
    }

    protected String getNoPartsTitle() {
        return UINlsStrings.OpenPartDialog_NoParts_Title;
    }

    protected String getNoPartsMessage() {
        return UINlsStrings.OpenPartDialog_NoParts_Message;
    }

    protected int addParts(ArrayList partsList, final IEGLSearchScope scope, final int elementKinds, final String subType) {
        final ArrayList typeList = new ArrayList();
        if (AllPartsCache.isCacheUpToDate()) {
            try {
                AllPartsCache.getParts((IEGLSearchScope)scope, (int)elementKinds, (String)subType, null, typeList);
            }
            catch (EGLModelException eGLModelException) {
                EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage);
                return 1;
            }
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AllPartsCache.getParts((IEGLSearchScope)scope, (int)elementKinds, (String)subType, (IProgressMonitor)monitor, (Collection)typeList);
                }
                catch (EGLModelException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            this.fRunnableContext.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        partsList.addAll(typeList);
        return 0;
    }

    protected IPart getPartFromPartInfo(PartInfo ref) {
        IPart type = null;
        try {
            type = ref.resolvePart(this.fScope);
            if (type == null) {
                String title = UINlsStrings.OpenPartErrorTitle;
                String message = UINlsStrings.OpenPartErrorMessage;
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            } else {
                ArrayList<IPart> result = new ArrayList<IPart>(1);
                result.add(type);
            }
        }
        catch (EGLModelException e) {
            String title = UINlsStrings.OpenPartErrorTitle;
            String message = UINlsStrings.OpenPartDialog_ErrorMessage;
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
            this.setResult(null);
        }
        return type;
    }

    protected void computeResult() {
        PartInfo ref = (PartInfo)this.getLowerSelectedElement();
        if (ref == null) {
            return;
        }
        IPart type = this.getPartFromPartInfo(ref);
        if (type == null) {
            this.setResult(null);
        } else {
            ArrayList<IPart> result = new ArrayList<IPart>(1);
            result.add(type);
            this.setResult(result);
        }
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        private TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof PartInfo)) {
                return false;
            }
            PartInfo type = (PartInfo)element;
            if (!this.fMatcher.match(type.getPartName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(type.getPartContainerName());
        }

        private String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        pattern = String.valueOf(pattern) + '*';
                    }
                }
            }
            return pattern;
        }
    }
}

