/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.StandardEGLElementContentProvider;
import org.eclipse.edt.ide.ui.internal.deployment.Include;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementSorter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.TypedViewerFilter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileBrowseDialog {
    public static ElementTreeSelectionDialog openBrowseFileDialog(Shell shell, IProject project, IFile initWSDLFile, boolean isWorkspaceScope, boolean showEGLProjectsOnly, String helpId, String filterFileExtension, String dialogTitle, String dialogDescription, String validationMsgInsert) {
        return FileBrowseDialog.openBrowseFileDialog(shell, project, initWSDLFile, isWorkspaceScope, showEGLProjectsOnly, helpId, filterFileExtension, dialogTitle, dialogDescription, validationMsgInsert, null, null);
    }

    public static ElementTreeSelectionDialog openBrowseFileDialog(Shell shell, final IProject project, IFile initWSDLFile, final boolean isWorkspaceScope, boolean showEGLProjectsOnly, final String helpId, final String filterFileExtension, String dialogTitle, String dialogDescription, final String validationMsgInsert, final EList<Include> includes, final IFile currentFile) {
        IEGLProject eglProject = EGLCore.create((IProject)project);
        EGLElementLabelProvider lp = new EGLElementLabelProvider(EGLElementLabelProvider.SHOW_DEFAULT);
        StandardEGLElementContentProvider cp = new StandardEGLElementContentProvider();
        IEGLModel input = eglProject.getEGLModel();
        if (!showEGLProjectsOnly) {
            cp = new WorkbenchContentProvider();
            lp = new WorkbenchLabelProvider();
            input = project.getWorkspace().getRoot();
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, cp){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                if (helpId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
                }
                return control;
            }
        };
        dialog.setSorter((ViewerSorter)new EGLElementSorter());
        dialog.setTitle(dialogTitle);
        dialog.setMessage(dialogDescription);
        dialog.setInput((Object)input);
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IResource resource;
                if (selection.length == 1 && selection[0] instanceof IResource && (resource = (IResource)selection[0]).getType() == 1 && resource.getFileExtension().equalsIgnoreCase(filterFileExtension)) {
                    if (currentFile != null && resource.equals((Object)currentFile)) {
                        return new StatusInfo(4, NewWizardMessages.ChooseEGLDDDialog_Error_CurrentDD);
                    }
                    if (includes != null) {
                        for (Include include : includes) {
                            if (!include.getLocation().equalsIgnoreCase(resource.getFullPath().toString())) continue;
                            return new StatusInfo(4, NewWizardMessages.ChooseEGLDDDialog_Error_ImportedDD);
                        }
                    }
                    return new StatusInfo();
                }
                return new StatusInfo(4, NewWizardMessages.bind((String)NewWizardMessages.WSDLFileSelectionError, (Object)validationMsgInsert));
            }
        };
        dialog.setValidator(validator);
        try {
            final String[] refProjNames = eglProject.getRequiredProjectNames();
            Class[] acceptedClasses = new Class[]{IEGLModel.class, IPackageFragmentRoot.class, IPackageFragment.class, IEGLProject.class, IResource.class};
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null){

                @Override
                public boolean select(Viewer viewer, Object parent, Object element) {
                    if (isWorkspaceScope) {
                        if (element instanceof IResource) {
                            IResource resource = (IResource)element;
                            if (resource.getType() == 1) {
                                return resource.getFileExtension().equalsIgnoreCase(filterFileExtension);
                            }
                            return true;
                        }
                    } else {
                        if (element instanceof IPackageFragmentRoot) {
                            try {
                                return ((IPackageFragmentRoot)element).getKind() == 1;
                            }
                            catch (EGLModelException e) {
                                EGLLogger.log((Object)this, e);
                                return false;
                            }
                        }
                        if (element instanceof IResource) {
                            IResource resource = (IResource)element;
                            if (resource.getType() == 1) {
                                return resource.getFileExtension().equalsIgnoreCase(filterFileExtension);
                            }
                            return true;
                        }
                        if (element instanceof IEGLProject) {
                            IEGLProject eglProj = (IEGLProject)element;
                            return eglProj.getProject().equals((Object)project) || this.isReferencedProject(eglProj);
                        }
                    }
                    return super.select(viewer, parent, element);
                }

                private boolean isReferencedProject(IEGLProject eglProj) {
                    String projName = eglProj.getElementName();
                    int i = 0;
                    while (i < refProjNames.length) {
                        if (projName.equals(refProjNames[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            };
            dialog.addFilter((ViewerFilter)filter);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (initWSDLFile != null) {
            dialog.setInitialSelection((Object)initWSDLFile);
        }
        return dialog;
    }

    public static ElementTreeSelectionDialog openBrowseFileOnEGLPathDialog(Shell shell, final IProject project, IFile initFile, final String helpId, final String filterFileExtension, String dialogTitle, String dialogDescription, final String validationMsgInsert, final EList<Include> includes, final IFile currentFile) {
        IEGLProject eglProject = EGLCore.create((IProject)project);
        EGLElementLabelProvider lp = new EGLElementLabelProvider(EGLElementLabelProvider.SHOW_DEFAULT);
        StandardEGLElementContentProvider cp = new StandardEGLElementContentProvider();
        IEGLModel input = eglProject.getEGLModel();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, cp){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                if (helpId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
                }
                return control;
            }
        };
        dialog.setSorter((ViewerSorter)new EGLElementSorter());
        dialog.setTitle(dialogTitle);
        dialog.setMessage(dialogDescription);
        dialog.setInput((Object)input);
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IResource resource;
                if (selection.length == 1 && selection[0] instanceof IResource && (resource = (IResource)selection[0]).getType() == 1 && resource.getFileExtension().equalsIgnoreCase(filterFileExtension)) {
                    if (currentFile != null && resource.equals((Object)currentFile)) {
                        return new StatusInfo(4, NewWizardMessages.ChooseEGLDDDialog_Error_CurrentDD);
                    }
                    if (includes != null) {
                        for (Include include : includes) {
                            if (!include.getLocation().equalsIgnoreCase(resource.getFullPath().toString())) continue;
                            return new StatusInfo(4, NewWizardMessages.ChooseEGLDDDialog_Error_ImportedDD);
                        }
                    }
                    return new StatusInfo();
                }
                return new StatusInfo(4, NewWizardMessages.bind((String)NewWizardMessages.WSDLFileSelectionError, (Object)validationMsgInsert));
            }
        };
        dialog.setValidator(validator);
        final HashSet<String> refProjectNames = new HashSet<String>();
        FileBrowseDialog.getProjectPath(eglProject, refProjectNames, new HashSet<IEGLProject>());
        Class[] acceptedClasses = new Class[]{IEGLModel.class, IPackageFragmentRoot.class, IPackageFragment.class, IEGLProject.class, IResource.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (EGLModelException e) {
                        EGLLogger.log((Object)this, e);
                        return false;
                    }
                }
                if (element instanceof IResource) {
                    if (parent instanceof IEGLProject) {
                        return false;
                    }
                    IResource resource = (IResource)element;
                    if (resource.getType() == 1) {
                        return resource.getFileExtension().equalsIgnoreCase(filterFileExtension);
                    }
                    return true;
                }
                if (element instanceof IEGLProject) {
                    IEGLProject eglProj = (IEGLProject)element;
                    return eglProj.getProject().equals((Object)project) || refProjectNames.contains(eglProj.getElementName());
                }
                return super.select(viewer, parent, element);
            }
        };
        dialog.addFilter((ViewerFilter)filter);
        if (initFile != null) {
            dialog.setInitialSelection((Object)initFile);
        }
        return dialog;
    }

    private static void getProjectPath(IEGLProject project, HashSet<String> projectNames, HashSet<IEGLProject> seen) {
        if (seen.contains(project)) {
            return;
        }
        seen.add(project);
        try {
            String[] projects = project.getRequiredProjectNames();
            projectNames.addAll(Arrays.asList(projects));
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IEGLProject eglProj;
                String next = stringArray[n2];
                IProject p = root.getProject(next);
                if (p.isAccessible() && (eglProj = EGLCore.create((IProject)p)) != null) {
                    FileBrowseDialog.getProjectPath(eglProj, projectNames, seen);
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
    }
}

