/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLValue;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugElement;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.debug.javascript.internal.model.RUIStackFrame;
import org.eclipse.edt.debug.javascript.internal.model.RUIVariable;

public class RUIValue
extends RUIDebugElement
implements IEGLValue {
    private static final IEGLVariable[] EMPTY_VARIABLES = new IEGLVariable[0];
    private String fValueString;
    private String fValueStringOld;
    private RUIVariable fVariable;
    private IEGLVariable[] fVariables;
    private boolean fValueChanged;
    private boolean fHasChildren;

    public RUIValue(RUIDebugTarget target, RUIVariable variable, boolean hasChildren, String oldValue) {
        super(target);
        this.fVariable = variable;
        this.fValueStringOld = oldValue;
        this.fHasChildren = hasChildren;
    }

    public String getReferenceTypeName() {
        return this.fVariable.getReferenceTypeName();
    }

    public String getValueString() {
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fVariables == null) {
            this.buildVariables();
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.fHasChildren;
    }

    private void buildVariables() {
        this.fVariables = this.fVariable.getVariables();
        if (this.fVariables == null) {
            this.fVariables = EMPTY_VARIABLES;
        } else {
            RUIStackFrame frame = this.fVariable.getStackFrame();
            IEGLVariable[] newVars = new IEGLVariable[this.fVariables.length];
            int i = 0;
            while (i < this.fVariables.length) {
                newVars[i] = frame.getCorrespondingVariable((RUIVariable)this.fVariables[i], this.fVariable);
                ++i;
            }
            this.fVariables = newVars;
        }
    }

    public boolean hasChanged() {
        return this.fValueChanged;
    }

    public void clearValue() {
        this.fValueStringOld = this.fValueString;
        this.fValueString = null;
    }

    public void setValue(String value) {
        if (this.fValueStringOld != null) {
            if (value != null) {
                if (!this.fValueStringOld.equals(value)) {
                    this.fValueChanged = true;
                }
            } else {
                this.fValueChanged = true;
            }
        }
        this.fValueString = value;
    }

    public IEGLVariable getParentVariable() {
        return this.fVariable;
    }
}

