/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootContainer;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLElementImageDescriptor;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public ElementImageProvider() {
        ISharedImages images = EDTUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    public Image getImageLabel(ImageDescriptor baseIcon, int flags) {
        return this.getImageLabel(this.getEGLImageDescriptor(baseIcon, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = EDTUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IEGLElement) {
            return this.getEGLImageDescriptor((IEGLElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("egl".equals(file.getFileExtension())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean useSmallSize(int flags) {
        return true;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = ElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new EGLElementImageDescriptor(PluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getEGLImageDescriptor(IEGLElement element, int flags) {
        int adornmentFlags = this.computeEGLAdornmentFlags(element, flags);
        Point size = ElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new EGLElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getEGLImageDescriptor(ImageDescriptor icon, int flags) {
        Point size = ElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new EGLElementImageDescriptor(icon, flags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = ElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new EGLElementImageDescriptor(descriptor, flags, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IEGLElement element, int renderFlags) {
        try {
            switch (element.getElementType()) {
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (root instanceof EglarPackageFragmentRootContainer) {
                        return PluginImages.DESC_OBJS_PACKFRAG_ROOT_EGLAR_CONTAINER;
                    }
                    if (root instanceof EglarPackageFragmentRoot) {
                        return PluginImages.DESC_OBJS_PACKFRAG_ROOT_EGLAR;
                    }
                    return PluginImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element, renderFlags);
                }
                case 6: {
                    return PluginImages.DESC_OBJS_EGLFILE;
                }
                case 7: {
                    return PluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    IEGLProject jp = (IEGLProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 1: {
                    return PluginImages.DESC_OBJS_EGL_MODEL;
                }
                case 10: {
                    return PluginImages.DESC_OBJS_FUNCTION;
                }
            }
            Assert.isTrue((boolean)false, (String)UINlsStrings.EGLImageLabelprovider_assert_wrongImage);
            return null;
        }
        catch (EGLModelException e) {
            if (e.isDoesNotExist()) {
                return PluginImages.DESC_OBJS_UNKNOWN;
            }
            EDTUIPlugin.log(e);
            return PluginImages.DESC_OBJS_GHOST;
        }
    }

    protected ImageDescriptor getPackageFragmentIcon(IEGLElement element, int renderFlags) throws EGLModelException {
        IPackageFragment fragment = (IPackageFragment)element;
        boolean containsEGLElements = false;
        try {
            containsEGLElements = fragment.hasChildren();
        }
        catch (EGLModelException eGLModelException) {}
        if (!containsEGLElements && fragment.getNonEGLResources().length > 0) {
            return PluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        if (!containsEGLElements) {
            return PluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return PluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeEGLAdornmentFlags(IEGLElement element, int renderFlags) {
        int flags = 0;
        if (renderFlags != 0) {
            return renderFlags;
        }
        return flags;
    }
}

