/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class ReadProgressMonitorDialog
extends ProgressMonitorDialog {
    public static final int SUCCESS = 0;
    public static final int CANCELED = 1;
    public static final int FAILED = 2;
    private final File file;
    private final URL url;
    private final StringBuffer input = new StringBuffer();
    private final StringBuffer error = new StringBuffer();
    private final Status status = new Status();

    public ReadProgressMonitorDialog(Shell parent, File file) {
        super(parent);
        this.file = file;
        this.url = null;
    }

    public ReadProgressMonitorDialog(Shell parent, URL url) {
        super(parent);
        this.url = url;
        this.file = null;
    }

    public void run() throws InvocationTargetException, InterruptedException {
        this.status.status = 0;
        super.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                if (ReadProgressMonitorDialog.this.url != null) {
                    try {
                        ReadProgressMonitorDialog.this.input.append(ReadProgressMonitorDialog.this.readFromStream(ReadProgressMonitorDialog.this.url.openStream(), monitor));
                    }
                    catch (Exception ex) {
                        ReadProgressMonitorDialog.this.error(ex.toString());
                    }
                } else {
                    try {
                        ReadProgressMonitorDialog.this.input.append(ReadProgressMonitorDialog.this.readFromStream(new FileInputStream(ReadProgressMonitorDialog.this.file), monitor));
                    }
                    catch (Exception ex) {
                        ReadProgressMonitorDialog.this.error(ex.getMessage());
                    }
                }
            }
        });
    }

    private void error(String message) {
        this.error.append(message);
        this.status.status = 2;
    }

    private String readFromStream(InputStream is, IProgressMonitor monitor) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String results = "";
        while ((inputLine = in.readLine()) != null) {
            if (monitor.isCanceled()) {
                this.status.status = 1;
                break;
            }
            results = String.valueOf(results) + inputLine + "\n";
        }
        in.close();
        return results;
    }

    public boolean isStatusSuccess() {
        return this.status.status == 0;
    }

    public boolean isStatusCanceled() {
        return this.status.status == 1;
    }

    public String getInput() {
        return this.input.toString();
    }

    public String getError() {
        return this.error.toString();
    }

    class Status {
        int status = 0;

        Status() {
        }
    }
}

