/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.property.pages.ArchiveFileFilter;
import org.eclipse.edt.ide.ui.internal.property.pages.FilteredElementTreeSelectionDialog;
import org.eclipse.edt.ide.ui.internal.property.pages.SourceAttachmentDialog;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.TypedElementSelectionValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public final class BuildPathDialogAccess {
    private BuildPathDialogAccess() {
    }

    public static IEGLPathEntry configureSourceAttachment(Shell shell, IEGLPathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(shell, initialEntry);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static IPath configureVariableEntry(Shell shell, IPath initialEntryPath, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static IEGLPathEntry configureContainerEntry(Shell shell, IEGLPathEntry initialEntry, IEGLProject project, IEGLPathEntry[] currentClasspath) {
        if (initialEntry == null || currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static IEGLPathEntry[] chooseContainerEntries(Shell shell, IEGLProject project, IEGLPathEntry[] currentClasspath) {
        if (currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public static IPath configureJAREntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (!curr.equals((Object)initialEntry) && (resource = root.findMember(usedEntries[i])) instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource existing = root.findMember(initialEntry);
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_EGLARArchiveDialog_edit_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_EGLARArchiveDialog_edit_description);
        dialog.setInitialFilter("*.eglar");
        dialog.addFilter(new ArchiveFileFilter(usedJars, true, true));
        dialog.setInput(root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection(existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseJAREntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_EGLARArchiveDialog_new_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_EGLARArchiveDialog_new_description);
        int orientation = Window.getDefaultOrientation();
        if (orientation == 0x4000000) {
            dialog.setInitialFilter(TextProcessor.process((String)"*.eglar", (String)"."));
        } else {
            dialog.setInitialFilter("*.eglar");
        }
        dialog.addFilter(new ArchiveFileFilter(usedJars, true, true));
        dialog.setInput(root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath configureExternalJAREntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtEGLARArchiveDialog_edit_title);
        dialog.setFilterExtensions(ArchiveFileFilter.EGLAR_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        EDTUIPlugin.getDefault().getDialogSettings().put("org.eclipse.edt.ide.ui.lastexteglar", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseExternalJAREntries(Shell shell) {
        String lastUsedPath = EDTUIPlugin.getDefault().getDialogSettings().get("org.eclipse.edt.ide.ui.lastexteglar");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtEGLARArchiveDialog_new_title);
        dialog.setFilterExtensions(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            ++i;
        }
        EDTUIPlugin.getDefault().getDialogSettings().put("org.eclipse.edt.ide.ui.lastexteglar", dialog.getFilterPath());
        return elems;
    }
}

