/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameProfileDialog
extends StatusDialog {
    private Label fNameLabel;
    private Text fNameText;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final StatusInfo fNoMessage;
    private final EObject fProfileOrDefaultProfile;
    private final ProfileManager fProfileManager;
    private Profile fRenamedProfile;

    public RenameProfileDialog(Shell parentShell, String dialogTitle, EObject profile, ProfileManager manager) {
        super(parentShell);
        this.fProfileManager = manager;
        this.setTitle(dialogTitle);
        this.fProfileOrDefaultProfile = profile;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, NewWizardMessages.Err_DuplicateFormatProfileName);
        this.fEmpty = new StatusInfo(4, NewWizardMessages.Err_EmptyFormatProfileName);
        this.fNoMessage = new StatusInfo(4, new String());
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNameLabel = new Label(composite, 0);
        this.fNameLabel.setText(NewWizardMessages.EnterNewName);
        this.fNameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        String profileDisplayName = this.fProfileManager.getProfileDisplayName(this.fProfileOrDefaultProfile);
        this.fNameText.setText(profileDisplayName);
        this.fNameText.setSelection(0, profileDisplayName.length());
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameProfileDialog.this.doValidation();
            }
        });
        this.fNameText.setText(profileDisplayName);
        this.fNameText.selectAll();
        RenameProfileDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (name.length() == 0) {
            this.updateStatus(this.fEmpty);
            return;
        }
        if (name.equals(this.fProfileManager.getProfileDisplayName(this.fProfileOrDefaultProfile))) {
            this.updateStatus(this.fNoMessage);
            return;
        }
        if (this.fProfileManager.containsProfile(name)) {
            this.updateStatus(this.fDuplicate);
            return;
        }
        this.updateStatus(this.fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        String newProfileName = this.fNameText.getText();
        if (this.fProfileManager.isProfileBuildIn(this.fProfileOrDefaultProfile)) {
            this.fRenamedProfile = this.fProfileManager.createNewProfile(newProfileName, this.fProfileOrDefaultProfile, false);
        } else {
            ((Profile)this.fProfileOrDefaultProfile).setName(newProfileName);
            this.fRenamedProfile = (Profile)this.fProfileOrDefaultProfile;
        }
        super.okPressed();
    }

    public Profile getRenamedProfile() {
        return this.fRenamedProfile;
    }
}

