/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.edt.ide.ui.internal.editor.IProblemChangedListener;
import org.eclipse.edt.ide.ui.internal.viewsupport.ElementImageProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EvEditorErrorUpdater
implements IProblemChangedListener {
    protected EvEditor _editor = null;
    protected ElementImageProvider _imageProvider = new ElementImageProvider();

    public EvEditorErrorUpdater(EvEditor editor) {
        this._editor = editor;
        EDTUIPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void dispose() {
        EDTUIPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }

    public void problemsChanged(IResource[] resources, boolean bMarkerChange) {
        if (bMarkerChange) {
            return;
        }
        IEditorInput input = this._editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].equals((Object)((FileEditorInput)input).getFile())) {
                this.updateEditorImage(input);
                break;
            }
            ++i;
        }
    }

    public void updateEditorImage(IEditorInput input) {
        Shell shell;
        Image imageCurrent = this._editor.getTitleImage();
        if (imageCurrent == null) {
            return;
        }
        int fImageFlags = EditorUtility.populateNodeErrorWarningHashMaps((EGLEditor)this._editor.getPageSource());
        final Image imageNew = this._imageProvider.getImageLabel(PluginImages.DESC_OBJS_EGLFILE, fImageFlags);
        if (imageCurrent != imageNew && (shell = this._editor.getEditorSite().getShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    EvEditorErrorUpdater.this._editor.updateTitleImage(imageNew);
                }
            });
        }
    }
}

