/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.java;

import java.util.HashSet;
import java.util.List;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.codegen.java.GenUtils;
import org.eclipse.edt.mof.codegen.java.MofImplTemplate;

public class EClassTemplate
extends MofImplTemplate {
    public void genImpl(EClass eClass, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        this.genImplPackageDecl(eClass, ctx, out);
        this.genImplImports(eClass, ctx, out);
        this.genImplClassHeader(eClass, ctx, out);
        this.genBaseClassBody(eClass, ctx, out);
        for (EField field : eClass.getEFields()) {
            Template fieldTemplate = ctx.getTemplateFor(field.getEClass());
            fieldTemplate.gen("genImplSetGet", field, ctx, out, new Object[0]);
        }
        for (EFunction function : eClass.getEFunctions()) {
            Template functionTemplate = ctx.getTemplateFor(function.getEClass());
            functionTemplate.gen("genImpl", function, ctx, out, new Object[0]);
        }
        out.popIndent();
        out.print('}');
    }

    public void genImplBase(EClass eClass, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        this.genImplPackageDecl(eClass, ctx, out);
        this.genImplImports(eClass, ctx, out);
        this.genBaseClassHeader(eClass, ctx, out);
        this.genBaseClassBody(eClass, ctx, out);
        for (EField field : eClass.getEFields()) {
            Template fieldTemplate = ctx.getTemplateFor(field.getEClass());
            fieldTemplate.gen("genImplSetGet", field, ctx, out, new Object[0]);
        }
        out.popIndent();
        out.print('}');
    }

    public void genImplExtendsBase(EClass eClass, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        this.genImplPackageDecl(eClass, ctx, out);
        HashSet<EClassifier> imports = new HashSet<EClassifier>();
        imports.add(eClass);
        for (EFunction function : eClass.getEFunctions()) {
            EType type = function.getEType();
            if (type != null && this.needsImport(type.getEClassifier())) {
                imports.add(type.getEClassifier());
            }
            for (EParameter parm : function.getEParameters()) {
                type = parm.getEType().getEClassifier();
                if (type == null || !this.needsImport((EClassifier)type)) continue;
                imports.add((EClassifier)type);
            }
        }
        for (EClassifier classifier : imports) {
            out.print("import ");
            out.print(classifier.getETypeSignature());
            out.println(";");
        }
        out.println();
        this.genImplExtendsBaseClassHeader(eClass, ctx, out);
        for (EFunction function : eClass.getEFunctions()) {
            Template functionTemplate = ctx.getTemplateFor(function.getEClass());
            functionTemplate.gen("genImpl", function, ctx, out, new Object[0]);
        }
        out.popIndent();
        out.print('}');
    }

    public void genInterface(EClass eClass, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        this.genPackageDecl(eClass, ctx, out);
        this.genImports(eClass, ctx, out);
        this.genClassHeader(eClass, ctx, out);
        for (EField field : eClass.getEFields()) {
            Template fieldTemplate = ctx.getTemplateFor(field.getEClass());
            fieldTemplate.gen("genInterfaceSetGet", field, ctx, out, new Object[0]);
        }
        for (EFunction function : eClass.getEFunctions()) {
            Template functionTemplate = ctx.getTemplateFor(function.getEClass());
            functionTemplate.gen("genInterface", function, ctx, out, new Object[0]);
        }
        out.popIndent();
        out.print('}');
    }

    public void genImplPackageDecl(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        out.print("package ");
        out.print(this.getPackageName(eClass, ctx));
        out.println(".impl;");
        out.println();
    }

    public void genImplImports(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        for (EClassifier type : GenUtils.getImportTypes(eClass, true)) {
            this.genImplImport(eClass, type, ctx, out);
        }
        out.println();
    }

    public void genImplImport(EClass eClass, EClassifier importType, TemplateContext ctx, TabbedWriter out) {
        if (!eClass.getSuperTypes().isEmpty() && eClass.getSuperTypes().get(0) == importType) {
            out.print("import ");
            out.print(this.getPackageName(importType, ctx));
            out.print(".impl.");
            out.print(importType.getEClassifier().getName());
            out.print("Impl");
            out.println(";");
        }
        out.print("import ");
        out.print(this.getETypeSignature(importType, ctx));
        out.println(';');
    }

    public void genBaseClassHeader(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        boolean noSuperType = this.getSuperType(eClass) == null;
        out.print("public abstract ");
        out.print("class ");
        out.print(eClass.getName());
        out.print("ImplBase");
        out.print(noSuperType ? " " : " extends " + this.getSuperType(eClass).getName() + "Impl");
        out.print(" implements ");
        out.print(eClass.getName());
        out.println(" {");
        out.pushIndent();
    }

    public void genImplExtendsBaseClassHeader(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        out.print("public");
        out.print(eClass.isAbstract() ? " abstract " : " ");
        out.print("class ");
        out.print(eClass.getName());
        out.print("Impl");
        out.print(" extends " + eClass.getName() + "ImplBase");
        out.print(" implements ");
        out.print(eClass.getName());
        out.println(" {");
        out.pushIndent();
    }

    public void genImplClassHeader(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        boolean noSuperType = this.getSuperType(eClass) == null;
        out.print("public");
        out.print(eClass.isAbstract() ? " abstract " : " ");
        out.print("class ");
        out.print(eClass.getName());
        out.print("Impl");
        out.print(noSuperType ? " " : " extends " + this.getSuperType(eClass).getName() + "Impl");
        out.print(" implements ");
        out.print(eClass.getName());
        out.println(" {");
        out.pushIndent();
    }

    public void genBaseClassBody(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        boolean noSuperType;
        boolean bl = noSuperType = this.getSuperType(eClass) == null;
        if (!eClass.getEFields().isEmpty()) {
            int i = 0;
            while (i < eClass.getEFields().size()) {
                out.println("private static int Slot_" + eClass.getEFields().get(i).getName() + "=" + i + ";");
                ++i;
            }
            out.println("private static int totalSlots = " + eClass.getEFields().size() + ";");
            out.println();
            out.println("public static int totalSlots() {");
            out.pushIndent();
            if (noSuperType) {
                out.println("return totalSlots;");
            } else {
                out.println("return totalSlots + " + GenUtils.getSuperType(eClass).getName() + "Impl.totalSlots();");
            }
            out.popIndent();
            out.println('}');
            out.println();
            if (!noSuperType) {
                out.println("static {");
                out.pushIndent();
                out.print("int offset = ");
                out.print(GenUtils.getSuperType(eClass).getName());
                out.println("Impl.totalSlots();");
                i = 0;
                while (i < eClass.getEFields().size()) {
                    out.println("Slot_" + eClass.getEFields().get(i).getName() + " += offset;");
                    ++i;
                }
                out.popIndent();
                out.println('}');
            }
        }
    }

    public void genPackageDecl(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        out.print("package ");
        out.print(this.getPackageName(eClass, ctx));
        out.println(';');
        out.println();
    }

    public void genImports(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        for (EClassifier type : this.getImportTypes(eClass, false)) {
            this.genImport(type, ctx, out);
        }
        out.println();
    }

    public void genImport(EClassifier type, TemplateContext ctx, TabbedWriter out) {
        out.print("import ");
        out.print(this.getETypeSignature(type, ctx));
        out.println(';');
    }

    public void genClassHeader(EClass eClass, TemplateContext ctx, TabbedWriter out) {
        boolean noSuperType = this.getSuperType(eClass) == null;
        out.print("public interface ");
        out.print(eClass.getName());
        if (!noSuperType) {
            out.print(" extends ");
            List<EClass> types = eClass.getSuperTypes();
            int i = 0;
            while (i < types.size()) {
                out.print(types.get(i).getName());
                if (i < types.size() - 1) {
                    out.print(", ");
                }
                ++i;
            }
        }
        out.println(" {");
        out.pushIndent();
    }
}

