/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.IProjectsChangedListener;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourceValueStoreUtility
implements IResourceChangeListener,
IProjectsChangedListener {
    private final String RESOURCE_ELEMENT = "resource";
    private final String STORED_VALUE_ELEMENT = "storedValue";
    private final String NAME_ATTRIBUTE = "name";
    private final String KEY_ATTRIBUTE = "key";
    private final String VALUE_ATTRIBUTE = "value";
    private static final ResourceValueStoreUtility INSTANCE = new ResourceValueStoreUtility();
    private static final String RESOURCE_VALUE_STORE_FILE_NAME = ".eglproject";
    private HashMap resourceValueStores = new HashMap();
    private ArrayList resourceStoreLRUList = new ArrayList();
    private static final int MAX_RESOURCE_STORES = 2;
    private static SAXParser parser = null;

    private ResourceValueStoreUtility() {
        EGLModelManager.getEGLModelManager().deltaProcessor.addProjectsChangedListener(this);
    }

    private SAXParser initParser() {
        SAXParser result = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        return result;
    }

    public static final ResourceValueStoreUtility getInstance() {
        return INSTANCE;
    }

    public synchronized ResourceValueStore getNewResourceValueStore(IProject project) {
        return this.readStore(project, true);
    }

    public synchronized ResourceValueStore getResourceValueStore(IProject project) {
        return this.getResourceValueStore(project, true);
    }

    public synchronized ResourceValueStore getResourceValueStore(IProject project, boolean forceMigration) {
        ResourceValueStore valueStore = (ResourceValueStore)this.resourceValueStores.get(project);
        if (valueStore == null) {
            if (this.resourceStoreLRUList.size() + 1 > 2) {
                this.resourceValueStores.remove(this.resourceStoreLRUList.remove(this.resourceStoreLRUList.size() - 1));
            }
            valueStore = this.readStore(project, forceMigration);
            this.resourceValueStores.put(project, valueStore);
        } else {
            this.resourceStoreLRUList.remove(project);
        }
        this.resourceStoreLRUList.add(0, project);
        return valueStore;
    }

    public String getValue(IResource resource, QualifiedName key) throws CoreException {
        return this.getValue(resource, key, true);
    }

    public String getValue(IResource resource, QualifiedName key, boolean forceMigration) throws CoreException {
        this.validateParameters(resource, key);
        return this.getResourceValueStore(resource.getProject(), forceMigration).getValue(resource, key);
    }

    public String getValueWithoutCache(IResource resource, QualifiedName key) throws CoreException {
        this.validateParameters(resource, key);
        IProject project = resource.getProject();
        ResourceValueStore valueStore = null;
        valueStore = this.readStore(project, true);
        return valueStore.getValue(resource, key);
    }

    public void setValue(IResource resource, QualifiedName key, String value) throws CoreException {
        this.validateParameters(resource, key);
        IProject project = resource.getProject();
        ResourceValueStore valueStore = this.getResourceValueStore(project, true);
        valueStore.setValue(resource, key, value);
        this.writeStore(project, valueStore);
    }

    private void validateParameters(IResource resource, QualifiedName key) throws CoreException {
        if (resource.exists()) {
            if (resource.getType() == 4 && !((IProject)resource).isOpen()) {
                throw new CoreException((IStatus)new Status(4, "myplugin", 0, "Project is closed", null));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "myplugin", 0, "Resource does not exist", null));
        }
        if (key == null) {
            throw new CoreException((IStatus)new Status(4, "myplugin", 0, "Key is null", null));
        }
    }

    private ResourceValueStore readStore(IProject project, boolean forceMigration) {
        ResourceValueStore valueStore = new ResourceValueStore(project);
        try {
            IFile resourceFile;
            String encode = "UTF-8";
            if (forceMigration) {
                encode = this.migrateEGLProjectFile2UTF8(project);
            }
            if ((resourceFile = project.getFile(RESOURCE_VALUE_STORE_FILE_NAME)).exists()) {
                ResourceValueStoreDefaultHandler handler = new ResourceValueStoreDefaultHandler(valueStore);
                if (parser == null) {
                    this.initParser();
                }
                BufferedInputStream inputStream = new BufferedInputStream(resourceFile.getContents(true));
                try {
                    parser.parse((InputStream)inputStream, (DefaultHandler)handler);
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            valueStore.setEncode(encode);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return valueStore;
    }

    private String migrateEGLProjectFile2UTF8(IProject project) throws CoreException {
        String encode = "UTF-8";
        IFile resourceFile = project.getFile(RESOURCE_VALUE_STORE_FILE_NAME);
        try {
            if (resourceFile.exists()) {
                BufferedInputStream inputStream = new BufferedInputStream(resourceFile.getContents(true));
                byte[] bytesContents = Util.getInputStreamAsByteArray(inputStream, -1);
                inputStream.close();
                String reg = "<\\s*\\?\\s*xml\\s*version\\s*=.*\\?\\s*>";
                Pattern pattern = Pattern.compile(reg, 2);
                Matcher matcher = pattern.matcher(new String(bytesContents));
                if (matcher.find()) {
                    String decl = matcher.group();
                    reg = "encoding\\s*=\\s*\".*\"";
                    pattern = Pattern.compile(reg, 2);
                    matcher = pattern.matcher(decl);
                    if (matcher.find() && (matcher = (pattern = Pattern.compile("\".*\"", 2)).matcher(matcher.group())).find()) {
                        encode = matcher.group().replaceAll("\"", "").trim();
                    }
                    return encode;
                }
                StringBuffer temp = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                temp.append(new String(bytesContents));
                IFile outputFile = project.getFile(RESOURCE_VALUE_STORE_FILE_NAME);
                outputFile.setContents((InputStream)new ByteArrayInputStream(temp.toString().getBytes("UTF-8")), true, false, null);
                outputFile.setCharset("UTF-8", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encode;
    }

    public void writeStore(IProject project, ResourceValueStore valueStore) {
        valueStore.write(new ResourceValueStoreFileWriter(project.getFile(RESOURCE_VALUE_STORE_FILE_NAME)));
    }

    public void clearCache() {
        this.resourceStoreLRUList.clear();
        this.resourceValueStores.clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        final ArrayList removed = new ArrayList();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() != 2) {
                    return true;
                }
                IResource resource = delta.getResource();
                removed.add(resource);
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
        }
        catch (CoreException coreException) {}
        removed.size();
    }

    @Override
    public void projectsChanged(IProject[] projects) {
        this.resourceValueStores.clear();
    }

    public class ResourceValueStore {
        private HashMap resourcesToNodes = new HashMap();
        private IProject project = null;
        private String encode = "";

        public ResourceValueStore(IProject project) {
            this.project = project;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        private ResourceValueStoreNode getNode(IResource resource) {
            return (ResourceValueStoreNode)this.resourcesToNodes.get(resource.getFullPath());
        }

        private void removeNode(IResource resource) {
            this.resourcesToNodes.remove(resource.getFullPath());
        }

        private void addNode(IResource resource, ResourceValueStoreNode node) {
            this.resourcesToNodes.put(resource.getFullPath(), node);
        }

        public String getValue(IResource resource, QualifiedName key) {
            String result = null;
            ResourceValueStoreNode node = this.getNode(resource);
            if (node != null) {
                result = node.getValue(key);
            }
            return result;
        }

        public void setValue(IResource resource, QualifiedName key, String value) {
            this.setValue(resource.getFullPath(), key, value);
        }

        public void setValue(IPath path, QualifiedName key, String value) {
            ResourceValueStoreNode node = (ResourceValueStoreNode)this.resourcesToNodes.get(path);
            if (node == null) {
                node = this.createNode(path);
            }
            node.setValue(key, value);
        }

        private ResourceValueStoreNode createNode(IPath path) {
            ResourceValueStoreNode result = null;
            String resourceName = path.lastSegment();
            if (path.segmentCount() > 1) {
                IPath parentPath = path.removeLastSegments(1);
                ResourceValueStoreNode parentNode = (ResourceValueStoreNode)this.resourcesToNodes.get(parentPath);
                if (parentNode == null) {
                    parentNode = this.createNode(parentPath);
                }
                if (parentNode != null) {
                    result = new ResourceValueStoreNode(resourceName);
                    result.setParent(parentNode);
                    parentNode.addChild(result);
                }
            } else {
                result = new ResourceValueStoreNode(resourceName);
            }
            if (result != null) {
                this.resourcesToNodes.put(path, result);
            }
            return result;
        }

        public void write(ResourceValueStoreFileWriter writer) {
            ResourceValueStoreNode node = (ResourceValueStoreNode)this.resourcesToNodes.get(this.project.getFullPath());
            if (node != null) {
                writer.writeStart(this.getEncode());
                this.writeResource(writer, node);
                writer.writeEnd();
            }
        }

        private void writeResource(ResourceValueStoreFileWriter writer, ResourceValueStoreNode node) {
            writer.writeResourceStart(node.getName());
            this.writeStoredValues(writer, node);
            ResourceValueStoreNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                ResourceValueStoreNode child = children[i];
                this.writeResource(writer, child);
                ++i;
            }
            writer.writeResourceEnd();
        }

        private void writeStoredValues(ResourceValueStoreFileWriter writer, ResourceValueStoreNode node) {
            QualifiedName[] keys = node.getStoredValueKeys();
            int i = 0;
            while (i < keys.length) {
                QualifiedName key = keys[i];
                writer.writeStoredValue(key.toString(), node.getValue(key));
                ++i;
            }
        }

        public void setProject(IProject newProject) {
            ResourceValueStoreNode node;
            if (this.project != null && (node = this.getNode((IResource)this.project)) != null) {
                node.setName(newProject.getName());
                this.removeNode((IResource)this.project);
                this.addNode((IResource)newProject, node);
            }
            this.project = newProject;
        }

        public HashMap getResourcesToNodes() {
            return this.resourcesToNodes;
        }
    }

    private class ResourceValueStoreDefaultHandler
    extends DefaultHandler {
        private Stack pathStack = new Stack();
        private IPath currentPath = null;
        private ResourceValueStore valueStore;

        public ResourceValueStoreDefaultHandler(ResourceValueStore store) {
            this.valueStore = store;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
            if (rawName.equals("resource")) {
                String name = atts.getValue("name");
                Path newPath = new Path(name);
                if (this.currentPath != null) {
                    newPath = this.currentPath.append(name);
                    this.pathStack.push(this.currentPath);
                }
                this.currentPath = newPath;
            } else if (rawName.equals("storedValue") && this.currentPath != null) {
                QualifiedName qName = this.createQualifiedName(atts.getValue("key"));
                String value = atts.getValue("value");
                this.valueStore.setValue(this.currentPath.makeAbsolute(), qName, value);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) {
            if (rawName.equals("resource")) {
                this.currentPath = this.pathStack.size() > 0 ? (IPath)this.pathStack.pop() : null;
            }
        }

        private QualifiedName createQualifiedName(String name) {
            int colonLocation = name.indexOf(":");
            String qualifier = null;
            String localName = null;
            if (colonLocation != -1) {
                qualifier = name.substring(0, colonLocation);
            }
            localName = name.substring(colonLocation + 1, name.length());
            return new QualifiedName(qualifier, localName);
        }
    }

    public class ResourceValueStoreFileWriter {
        StringBuffer output = new StringBuffer();
        int tabCount = 0;
        private IFile outputFile;
        private String xmlEncode = "";

        public ResourceValueStoreFileWriter(IFile outputFile) {
            this.outputFile = outputFile;
        }

        public void writeStart(String xmlEncoding) {
            this.xmlEncode = xmlEncoding;
            this.output.append("<?xml version=\"1.0\" encoding=\"" + xmlEncoding + "\"?>\n");
        }

        public String getOutputString() {
            return this.output.toString();
        }

        public void writeEnd() {
            if (this.outputFile != null) {
                ByteArrayInputStream inputStream = null;
                try {
                    inputStream = new ByteArrayInputStream(this.getOutputString().getBytes(this.xmlEncode));
                    if (!this.outputFile.exists()) {
                        this.outputFile.create((InputStream)inputStream, true, null);
                    } else {
                        this.outputFile.setContents((InputStream)inputStream, true, false, null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }

        public void writeResourceStart(String name) {
            this.outputTabs(this.tabCount);
            this.output.append("<");
            this.output.append("resource");
            this.output.append(" ");
            this.output.append("name");
            this.output.append("=\"");
            this.output.append(name);
            this.output.append("\">\n");
            ++this.tabCount;
        }

        public void writeResourceEnd() {
            --this.tabCount;
            this.outputTabs(this.tabCount);
            this.output.append("</");
            this.output.append("resource");
            this.output.append(">\n");
        }

        public void writeStoredValue(String key, String value) {
            if (value != null) {
                this.outputTabs(this.tabCount);
                this.output.append("<");
                this.output.append("storedValue");
                this.output.append(" ");
                this.output.append("key");
                this.output.append("=\"");
                this.output.append(key);
                this.output.append("\" ");
                this.output.append("value");
                this.output.append("=\"");
                this.output.append(value);
                this.output.append("\"/>\n");
            }
        }

        private void outputTabs(int tabCount) {
            int i = 0;
            while (i < tabCount) {
                this.output.append("\t");
                ++i;
            }
        }
    }

    public class ResourceValueStoreNode {
        private String name = null;
        private HashMap valuesMap = new HashMap();
        private ResourceValueStoreNode parent = null;
        private ArrayList children = new ArrayList();

        public ResourceValueStoreNode(String name) {
            this.name = name;
        }

        public void setValue(QualifiedName key, String value) {
            this.valuesMap.put(key, value);
        }

        public String getValue(QualifiedName key) {
            return (String)this.valuesMap.get(key);
        }

        public String getName() {
            return this.name;
        }

        public ResourceValueStoreNode[] getChildren() {
            return this.children.toArray(new ResourceValueStoreNode[this.children.size()]);
        }

        public QualifiedName[] getStoredValueKeys() {
            Set valueKeys = this.valuesMap.keySet();
            return valueKeys.toArray(new QualifiedName[valueKeys.size()]);
        }

        public ResourceValueStoreNode getParent() {
            return this.parent;
        }

        public void setParent(ResourceValueStoreNode parent) {
            this.parent = parent;
        }

        public void addChild(ResourceValueStoreNode child) {
            this.children.add(child);
        }

        public void setName(String name) {
            this.name = name;
        }

        public HashMap getValuesMap() {
            return this.valuesMap;
        }
    }
}

