/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.edt.ide.core.internal.model.EGLElementRequestor;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.IEGLElementRequestor;
import org.eclipse.edt.ide.core.internal.model.NameLookup;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;

public class EGLModelNameEnvironment {
    static final IPart[] fEmptyPartsArray = new IPart[0];
    protected NameLookup nameLookup;
    protected Hashtable eglFileImportsCache;
    protected IEGLProject project;
    private IEGLFile currentEGLFile;

    private void addEGLFile(IEGLFile file) {
        try {
            IImportDeclaration[] imports = file.getImports();
            ArrayList<String> elements = new ArrayList<String>();
            elements.add(file.getParent().getElementName());
            if (imports.length > 0) {
                int i = 0;
                while (i < imports.length) {
                    IImportDeclaration imp = imports[i];
                    String impName = imp.getElementName();
                    String pkgName = null;
                    int index = impName.lastIndexOf(46);
                    pkgName = index != -1 ? impName.substring(0, index) : impName;
                    elements.add(pkgName);
                    ++i;
                }
            }
            this.eglFileImportsCache.put(file, elements);
        }
        catch (EGLModelException eGLModelException) {}
    }

    public EGLModelNameEnvironment(IEGLProject project) throws EGLModelException {
        this.project = project;
        this.nameLookup = ((EGLProject)project).getNameLookup();
        this.eglFileImportsCache = new Hashtable();
    }

    public IPart[] findParts(String name, IEGLFile file) {
        if (name == null) {
            return fEmptyPartsArray;
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String partName = name.substring(0, i);
            String packageName = name.substring(i + 1);
            return this.findParts(partName, packageName);
        }
        List imports = (List)this.eglFileImportsCache.get(file);
        if (imports == null) {
            this.addEGLFile(file);
            imports = (List)this.eglFileImportsCache.get(file);
        }
        IPart[] parts = this.findParts(name, imports);
        return parts;
    }

    private IPart[] findParts(String name, String packageName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(packageName);
        return this.findParts(name, names);
    }

    private IPart[] findParts(String name, List packageNames) {
        if (name == null) {
            return fEmptyPartsArray;
        }
        EGLElementRequestor requestor = new EGLElementRequestor();
        this.findParts(name, packageNames, requestor);
        return requestor.getParts();
    }

    private void findParts(String name, List packageName, IEGLElementRequestor requestor) {
        this.findParts(name, packageName, requestor, 4);
    }

    private void findParts(String partName, List packageNames, IEGLElementRequestor requestor, int type) {
        for (String packageName : packageNames) {
            this.nameLookup.seekPackageFragments(packageName, false, requestor);
        }
        IPackageFragment[] fragments = ((EGLElementRequestor)requestor).getPackageFragments();
        if (fragments != null) {
            int i = 0;
            int length = fragments.length;
            while (i < length) {
                if (fragments[i] != null) {
                    this.nameLookup.seekParts(partName, fragments[i], false, type, requestor);
                }
                ++i;
            }
        }
    }

    protected String toStringArray(String[] names) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            result.append(names[i].toString());
            ++i;
        }
        return result.toString();
    }

    public void cleanup() {
        this.eglFileImportsCache = null;
        this.project = null;
        this.nameLookup = null;
    }
}

