/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class DeletePackageFragmentRootOperation
extends EGLModelOperation {
    int updateResourceFlags;
    int updateModelFlags;

    public DeletePackageFragmentRootOperation(IPackageFragmentRoot root, int updateResourceFlags, int updateModelFlags) {
        super(root);
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        IEGLPathEntry rootEntry = root.getRawEGLPathEntry();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.deleteResource(root, rootEntry);
        }
        if ((this.updateModelFlags & 2) != 0) {
            this.updateProjectClasspath(rootEntry.getPath(), root.getEGLProject());
        }
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectClasspaths(rootEntry.getPath(), root.getEGLProject());
        }
    }

    protected void deleteResource(IPackageFragmentRoot root, IEGLPathEntry rootEntry) throws EGLModelException {
        char[][] exclusionPatterns = ((EGLPathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (rootEntry.getEntryKind() != 3 || exclusionPatterns == null) {
            try {
                rootResource.delete(this.updateResourceFlags, this.fMonitor);
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
        }
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 2) {
                    IPath path = proxy.requestFullPath();
                    if (DeletePackageFragmentRootOperation.this.prefixesOneOf(path, nestedFolders)) {
                        return !DeletePackageFragmentRootOperation.this.equalsOneOf(path, nestedFolders);
                    }
                    proxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.fMonitor);
                    return false;
                }
                proxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.fMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectClasspaths(IPath rootPath, IEGLProject projectOfRoot) throws EGLModelException {
        IEGLModel model = this.getEGLModel();
        IEGLProject[] projects = model.getEGLProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IEGLProject project = projects[i];
            if (!project.equals(projectOfRoot)) {
                this.updateProjectClasspath(rootPath, project);
            }
            ++i;
        }
    }

    protected void updateProjectClasspath(IPath rootPath, IEGLProject project) throws EGLModelException {
        IEGLPathEntry[] classpath = project.getRawEGLPath();
        IEGLPathEntry[] newClasspath = null;
        int cpLength = classpath.length;
        int newCPIndex = -1;
        int j = 0;
        while (j < cpLength) {
            IEGLPathEntry entry = classpath[j];
            if (rootPath.equals((Object)entry.getPath())) {
                if (newClasspath == null) {
                    newClasspath = new IEGLPathEntry[cpLength - 1];
                    System.arraycopy(classpath, 0, newClasspath, 0, j);
                    newCPIndex = j;
                }
            } else if (newClasspath != null) {
                newClasspath[newCPIndex++] = entry;
            }
            ++j;
        }
        if (newClasspath != null) {
            if (newCPIndex < newClasspath.length) {
                IEGLPathEntry[] iEGLPathEntryArray = newClasspath;
                newClasspath = new IEGLPathEntry[newCPIndex];
                System.arraycopy(iEGLPathEntryArray, 0, newClasspath, 0, newCPIndex);
            }
            project.setRawEGLPath(newClasspath, this.fMonitor);
        }
    }

    @Override
    protected IEGLModelStatus verify() {
        IEGLModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new EGLModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new EGLModelStatus(995, root);
        }
        return EGLModelStatus.VERIFIED_OK;
    }
}

