/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.ide.core.internal.errors.ErrorNode;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;

public class ParseTreePrinter {
    private static final String INDENT = "  ";

    public static void printError(ParseNode node) {
        if (node.isError()) {
            ErrorNode errorNode = (ErrorNode)((Object)node);
            System.out.println(errorNode.getErrorMessage());
        } else if (node.isNonTerminal()) {
            NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
            ParseNode[] children = nonTerminalNode.children;
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    ParseTreePrinter.printError(children[i]);
                    ++i;
                }
            }
        }
    }

    public static void print(ParseNode node) {
        ParseTreePrinter.print(node, "");
    }

    private static void print(ParseNode node, String indent) {
        System.out.print(indent);
        if (node.isTerminal()) {
            System.out.println(String.valueOf(ParseTreePrinter.getTerminalLabel((TerminalNode)node)) + " " + ParseTreePrinter.getTerminalText((TerminalNode)node));
        } else {
            NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
            System.out.println(ParseTreePrinter.getNonTerminalLabel(nonTerminalNode));
            ParseNode[] children = nonTerminalNode.children;
            if (children != null) {
                indent = String.valueOf(indent) + INDENT;
                int i = 0;
                while (i < children.length) {
                    ParseTreePrinter.print(children[i], indent);
                    ++i;
                }
            }
        }
    }

    public static String getTerminalLabel(TerminalNode terminalNode) {
        String label = NodeNameUtility.getTerminalName((int)terminalNode.terminalType);
        return terminalNode.isError() ? "Error " + label : label;
    }

    public static String getTerminalText(TerminalNode terminalNode) {
        return ParseTreePrinter.format(terminalNode.getText());
    }

    public static String format(String string) {
        StringBuffer buffer = new StringBuffer(string.length() * 2);
        buffer.append('\"');
        int i = 0;
        while (i < string.length()) {
            switch (string.charAt(i)) {
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                default: {
                    buffer.append(string.charAt(i));
                }
            }
            ++i;
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String getLabel(ParseNode node) {
        return node.isTerminal() ? ParseTreePrinter.getTerminalLabel((TerminalNode)node) : ParseTreePrinter.getNonTerminalLabel((NonTerminalNode)node);
    }

    public static String getNonTerminalLabel(NonTerminalNode nonTerminalNode) {
        String label;
        if (nonTerminalNode.isWhiteSpace()) {
            String childLabel = ParseTreePrinter.getLabel(nonTerminalNode.children[0]);
            label = String.valueOf(childLabel) + "-connector";
        } else {
            label = NodeNameUtility.getNonterminalName((int)nonTerminalNode.nonTerminalType);
        }
        return nonTerminalNode.isError() ? "Error " + label : label;
    }
}

