/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.internal.builder.AbstractBuilder;
import org.eclipse.edt.ide.core.internal.builder.BatchProcessingQueue;
import org.eclipse.edt.ide.core.internal.builder.Builder;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class AbstractBatchBuilder
extends AbstractBuilder {
    protected AbstractBatchBuilder(Builder builder, IBuildNotifier notifier) {
        super(builder, notifier);
        this.processingQueue = new BatchProcessingQueue(builder.getProject(), notifier);
    }

    @Override
    protected void build() {
        this.notifier.subTask(BuilderResources.buildAnalyzingAllEGLFiles);
        this.addAllEGLFiles();
    }

    protected void addAllEGLFiles() {
        try {
            IContainer[] sourceLocations = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.builder.getProject()).getSourceLocations();
            int i = 0;
            int l = sourceLocations.length;
            while (i < l) {
                IContainer sourceLocation = sourceLocations[i];
                final int segmentCount = sourceLocation.getFullPath().segmentCount();
                IResource[] children = sourceLocation.members();
                int j = 0;
                while (j < children.length) {
                    children[j].accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            IResource resource = proxy.requestResource();
                            switch (proxy.getType()) {
                                case 1: {
                                    if (!AbstractBatchBuilder.this.processedFiles.contains(resource)) {
                                        IFile file = (IFile)resource;
                                        String packageName = NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1)));
                                        if (Util.isEGLFileName(proxy.getName())) {
                                            AbstractBatchBuilder.this.addEGLFile(file, packageName);
                                        }
                                        if (AbstractBatchBuilder.this.isOKToCopy(proxy.getName())) {
                                            AbstractBatchBuilder.this.copyFileToOutputLocation(file, packageName);
                                        }
                                    }
                                    return false;
                                }
                                case 2: {
                                    AbstractBatchBuilder.this.addEGLPackage(NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(resource.getFullPath().removeFirstSegments(segmentCount))));
                                }
                            }
                            return true;
                        }
                    }, 0);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected abstract void addEGLPackage(String var1);

    protected abstract void addEGLFile(IFile var1, String var2);
}

