/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclipse.ecf.internal.remoteservice.Messages;
import org.eclipse.ecf.remoteservice.IRemoteCall;

public class RemoteCallMethod
implements IRemoteCall {
    public static final int DEFAULT_TIMEOUT = 30000;
    protected static final Object[] EMPTY_PARAMETERS = new Object[0];
    protected Method method;
    protected Object[] parameters;
    protected long timeout;

    public static void checkSerializable(Object[] parameters) throws NotSerializableException {
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!(parameters instanceof Serializable)) {
                throw new NotSerializableException(Messages.RemoteCallMethod_EXCEPTION_PARAMETER_NOT_SERIALIZABLE);
            }
            ++i;
        }
    }

    public static void checkForTypeMatch(Method method, Object[] parameters) {
        if (parameters == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException(Messages.RemoteCallMethod_EXCEPTION_ARGS_NOT_RIGHT_LENGTH);
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (!parameterTypes[i].isInstance(parameters[i])) {
                throw new IllegalArgumentException(Messages.RemoteCallMethod_EXCEPTION_ARG_WRONG_TYPE);
            }
            ++i;
        }
    }

    public void setParameters(Object[] parameters) throws NotSerializableException {
        if (parameters != null) {
            RemoteCallMethod.checkSerializable(parameters);
            RemoteCallMethod.checkForTypeMatch(this.method, parameters);
            this.parameters = parameters;
        } else {
            this.parameters = EMPTY_PARAMETERS;
        }
    }

    public RemoteCallMethod(Method method, Object[] parameters, long timeout) throws NotSerializableException {
        this.method = method;
        this.timeout = timeout;
        this.setParameters(parameters);
    }

    public RemoteCallMethod(Method method, Object[] parameters) throws NotSerializableException {
        this(method, parameters, 30000L);
    }

    public RemoteCallMethod(Method method, long timeout) {
        this.method = method;
        this.timeout = timeout;
        this.parameters = EMPTY_PARAMETERS;
    }

    public RemoteCallMethod(Method method) {
        this(method, 30000L);
    }

    public String getMethod() {
        return this.method.getName();
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

