/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.attachments.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.eclipse.ebpm.attachments.IAttachmentStore;
import org.eclipse.ebpm.metadb.attachments.model.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAttachmentStore
implements IAttachmentStore {
    public static final String NON_JTA_DATASOURCE = "javax.persistence.nonJtaDataSource";
    private static final String PERSISTENCE_UNIT = "org.eclipse.ebpm.metadb.attachments";
    private static Logger logger = LoggerFactory.getLogger(DBAttachmentStore.class);
    private javax.sql.DataSource ds = null;
    private Map<String, javax.sql.DataSource> properties = null;
    private EntityManagerFactory emf = null;
    private EntityManager em = null;
    private String attachmentStoreId = null;

    public DBAttachmentStore(javax.sql.DataSource ds) {
        this.ds = ds;
        this.properties = new HashMap<String, javax.sql.DataSource>();
        this.properties.put(NON_JTA_DATASOURCE, ds);
        this.emf = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT, this.properties);
        this.em = this.emf.createEntityManager();
    }

    @Override
    public void delete(String id) {
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            Query query = this.em.createQuery("delete from Attachment where id = :id");
            query.setParameter("id", (Object)Long.parseLong(id));
            query.executeUpdate();
            tx.commit();
        }
        catch (Throwable e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new RuntimeException("Attachment deletion failure", e);
        }
    }

    @Override
    public DataHandler load(String id) {
        try {
            Attachment attachment = (Attachment)this.em.find(Attachment.class, (Object)new Long(id));
            byte[] result = attachment.getData();
            int blen = result.length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(result, 0, blen);
            baos.flush();
            baos.close();
            ByteArrayDataSource bads = new ByteArrayDataSource(baos.toByteArray(), "application/octet-stream");
            DataHandler dha = new DataHandler((DataSource)bads);
            return dha;
        }
        catch (Throwable e) {
            throw new RuntimeException("Attachment load failure", e);
        }
    }

    public void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    @Override
    public String store(String name, String correlationID, DataHandler value) {
        EntityTransaction tx = null;
        try {
            int read;
            tx = this.em.getTransaction();
            tx.begin();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = value.getInputStream();
            byte[] buf = new byte[4096];
            while ((read = is.read(buf)) > -1) {
                baos.write(buf, 0, read);
            }
            buf = null;
            Attachment attachment = new Attachment();
            attachment.setCorrelationid(name);
            attachment.setData(baos.toByteArray());
            this.em.persist((Object)attachment);
            tx.commit();
            return "" + attachment.getId();
        }
        catch (Throwable e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new RuntimeException("Attachment store failure", e);
        }
    }

    @Override
    public String getAttachmentStoreId() {
        return this.attachmentStoreId;
    }
}

