/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ecf.osgi.services.discovery.local.FileBasedDiscoveryImpl;
import org.eclipse.ecf.osgi.services.discovery.local.ServiceDescriptionParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.xml.sax.SAXException;

public class BundleTrackerImpl
implements BundleTrackerCustomizer {
    private FileBasedDiscoveryImpl discovery = null;
    private static final String REMOTESERVICE_LOCATION = "OSGI-INF" + File.separator + "remote-service";
    private static final String REMOTESERVICE_MANIFESTHEADER = "Remote-Service";
    private Collection checkedBundles = Collections.synchronizedList(new ArrayList());
    private Map publishedServicesPerBundle = Collections.synchronizedMap(new HashMap());

    public BundleTrackerImpl(FileBasedDiscoveryImpl disco) {
        this.discovery = disco;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        FileBasedDiscoveryImpl.log(3, "Adding bundle " + bundle.getSymbolicName() + " with event " + event);
        this.checkedBundles.add(String.valueOf(bundle.getBundleId()));
        return this.checkBundleAndPublishServices(bundle);
    }

    private Bundle checkBundleAndPublishServices(Bundle bundle) {
        Collection remoteServiceFiles = null;
        ArrayList<ServiceEndpointDescription> publishedServices = null;
        remoteServiceFiles = this.getRemoteServiceInformationFilesFromBundle(bundle);
        if (remoteServiceFiles.size() == 0) {
            return null;
        }
        Iterator it = remoteServiceFiles.iterator();
        publishedServices = new ArrayList<ServiceEndpointDescription>();
        while (it.hasNext()) {
            Collection seds = this.createSEDsFromFile((URL)it.next());
            Iterator sedIterator = seds.iterator();
            while (sedIterator.hasNext()) {
                ServiceEndpointDescription next = (ServiceEndpointDescription)sedIterator.next();
                this.discovery.publishService(next);
                publishedServices.add(next);
            }
        }
        this.publishedServicesPerBundle.put(bundle, publishedServices);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        FileBasedDiscoveryImpl.log(3, "Removing bundle " + bundle.getSymbolicName() + " with event " + event);
        Collection publishedServices = (Collection)this.publishedServicesPerBundle.get(bundle);
        if (publishedServices != null) {
            Iterator it = publishedServices.iterator();
            while (it.hasNext()) {
                this.discovery.unpublishService((ServiceEndpointDescription)it.next());
            }
        }
        this.publishedServicesPerBundle.remove(bundle);
        this.checkedBundles.remove(String.valueOf(bundle.getBundleId()));
    }

    private Collection getRemoteServiceInformationFilesFromBundle(Bundle bundle) {
        ArrayList result;
        block3: {
            block2: {
                result = new ArrayList();
                String remote_services = (String)bundle.getHeaders().get(REMOTESERVICE_MANIFESTHEADER);
                if (remote_services == null) break block2;
                StringTokenizer tokenizer = new StringTokenizer(remote_services, ",");
                while (tokenizer.hasMoreElements()) {
                    this.handleRemoteService(bundle, result, tokenizer);
                }
                break block3;
            }
            Enumeration bundleEntries = bundle.findEntries(REMOTESERVICE_LOCATION, "*.xml", true);
            if (bundleEntries == null) break block3;
            while (bundleEntries.hasMoreElements()) {
                result.add(bundleEntries.nextElement());
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void handleRemoteService(Bundle bundle, Collection result, StringTokenizer tokenizer) {
        block8: {
            block9: {
                block7: {
                    token = tokenizer.nextToken().trim();
                    path = token.substring(0, token.lastIndexOf("/"));
                    start = path.indexOf("${");
                    if (start >= 0) {
                        end = path.indexOf("}");
                        substring = path.substring(start + 2, end);
                        property = System.getProperty(substring);
                        path = path.replaceAll("\\$\\{" + substring + "\\}", property);
                    }
                    if ((enumeration = bundle.findEntries(path, files = token.substring(token.lastIndexOf("/") + 1, token.length()), false)) != null) ** GOTO lbl28
                    f = new File(String.valueOf(path) + File.separator + files);
                    if (!f.isFile() || !f.exists()) break block7;
                    try {
                        result.add(f.toURL());
                    }
                    catch (MalformedURLException v0) {}
                    break block8;
                }
                if (!f.isDirectory() || !f.exists()) break block9;
                this.addFilesToResult(result, f);
                break block8;
            }
            if (!new File(path).isDirectory() || !(directory = new File(path)).exists() || !files.equals("*.xml")) break block8;
            this.addFilesToResult(result, directory);
            break block8;
lbl-1000:
            // 1 sources

            {
                result.add(enumeration.nextElement());
lbl28:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
    }

    private void addFilesToResult(Collection result, File f) {
        File[] filesInTheDirectory = f.listFiles(new FilenameFilter(){

            public boolean accept(File directory, String fileName) {
                return fileName.endsWith(".xml");
            }
        });
        int i = 0;
        while (i < filesInTheDirectory.length) {
            try {
                result.add(filesInTheDirectory[i].toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
    }

    private Collection createSEDsFromFile(URL file) {
        try {
            InputStream inputStream = file.openStream();
            return new ServiceDescriptionParser().load(inputStream);
        }
        catch (FileNotFoundException e) {
            this.log(file, e);
        }
        catch (ParserConfigurationException e) {
            this.log(file, e);
        }
        catch (SAXException e) {
            this.log(file, e);
        }
        catch (IOException e) {
            this.log(file, e);
        }
        return new ArrayList();
    }

    private void log(URL file, Exception e) {
        e.printStackTrace();
        FileBasedDiscoveryImpl.log(1, "Error during loading and reading of service descriptions from file " + file.getFile(), e);
    }
}

