/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core.sharedobject;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.sharedobject.ISharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.provider.ISharedObjectInstantiator;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.sharedobject.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.sharedobject";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String PROPERTY_ELEMENT_NAME = "property";
    protected static final String VALUE_ATTRIBUTE = "value";
    protected static final String NAMESPACE_NAME = "sharedObjectFactory";
    protected static final String SHAREDOBJECT_FACTORY_EPOINT = "org.eclipse.ecf.sharedobject.sharedObjectFactory";
    protected static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final int REMOVE_SHAREDOBJECT_ERRORCODE = 1001;
    private static final int FACTORY_NAME_COLLISION_ERRORCODE = 2001;
    private static Activator plugin;
    private BundleContext context = null;
    private IRegistryChangeListener registryManager = null;
    private ServiceTracker extensionRegistryTracker = null;
    private ServiceTracker logServiceTracker = null;
    private ServiceTracker adapterManagerTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public IExtensionRegistry getExtensionRegistry() {
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        plugin = this;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.extensionRegistryTracker = new ServiceTracker(ctxt, clazz.getName(), null);
        this.extensionRegistryTracker.open();
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            this.registryManager = new SharedObjectRegistryManager();
            registry.addRegistryChangeListener(this.registryManager);
        }
        this.setupSharedObjectExtensionPoint(ctxt);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.internal.core.sharedobject.Activator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/methods/entering", (Class)clazz2, (String)"start");
    }

    public void stop(BundleContext ctxt) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.internal.core.sharedobject.Activator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/methods/exiting", (Class)clazz, (String)"stop");
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            reg.removeRegistryChangeListener(this.registryManager);
        }
        this.registryManager = null;
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        if (adapterManager == null) {
            Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, "Cannot get adapter manager", null));
        }
        return adapterManager;
    }

    protected void removeSharedObjectExtensions(IConfigurationElement[] members) {
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String name = null;
            try {
                ISharedObjectFactory factory;
                SharedObjectTypeDescription sd;
                name = member.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if (name != null && (sd = (factory = SharedObjectFactory.getDefault()).getDescriptionByName(name)) != null && factory.containsDescription(sd)) {
                    factory.removeDescription(sd);
                    Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("removeSharedObjectExtensions.removedDescription(" + sd + ")"));
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ecf.internal.core.sharedobject.Activator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"removeSharedObjectExtensions", (Throwable)e);
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 1001, Messages.Activator_Exception_Removing_Extension, (Throwable)e));
            }
            ++m;
        }
    }

    protected void addSharedObjectExtensions(IConfigurationElement[] members) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            ISharedObjectInstantiator exten = null;
            String name = null;
            try {
                String description;
                exten = (ISharedObjectInstantiator)member.createExecutableExtension(CLASS_ATTRIBUTE);
                name = member.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if ((description = member.getAttribute(DESCRIPTION_ATTRIBUTE)) == null) {
                    description = "";
                }
                Map properties = this.getProperties(member.getChildren(PROPERTY_ELEMENT_NAME));
                SharedObjectTypeDescription scd = new SharedObjectTypeDescription(name, exten, description, properties);
                Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("setupSharedObjectExtensionPoint:createdDescription(" + scd + ")"));
                ISharedObjectFactory factory = SharedObjectFactory.getDefault();
                if (factory.containsDescription(scd)) {
                    throw new CoreException((IStatus)new Status(4, bundleName, 2001, "name=" + name + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
                }
                factory.addDescription(scd);
                Trace.trace((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug", (String)("setupSharedObjectExtensionPoint.addedDescriptionToFactory(" + scd + ")"));
            }
            catch (CoreException e) {
                Activator.getDefault().log(e.getStatus());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ecf.internal.core.sharedobject.Activator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"addSharedObjectExtensions", (Throwable)e);
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, bundleName, 2001, "name=" + name + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ecf.internal.core.sharedobject.Activator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching((String)PLUGIN_ID, (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"addSharedObjectExtensions", (Throwable)e);
            }
            ++m;
        }
    }

    protected void setupSharedObjectExtensionPoint(BundleContext bc) {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(SHAREDOBJECT_FACTORY_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            this.addSharedObjectExtensions(extensionPoint.getConfigurationElements());
        }
    }

    protected Map getProperties(IConfigurationElement[] propertyElements) {
        Properties props = new Properties();
        if (propertyElements != null && propertyElements.length > 0) {
            int i = 0;
            while (i < propertyElements.length) {
                String name = propertyElements[i].getAttribute(NAME_ATTRIBUTE);
                String value = propertyElements[i].getAttribute(VALUE_ATTRIBUTE);
                if (name != null && !name.equals("") && value != null && !value.equals("")) {
                    props.setProperty(name, value);
                }
                ++i;
            }
        }
        return props;
    }

    protected class SharedObjectRegistryManager
    implements IRegistryChangeListener {
        protected SharedObjectRegistryManager() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] delta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.NAMESPACE_NAME);
            int i = 0;
            while (i < delta.length) {
                switch (delta[i].getKind()) {
                    case 1: {
                        Activator.this.addSharedObjectExtensions(delta[i].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeSharedObjectExtensions(delta[i].getExtension().getConfigurationElements());
                    }
                }
                ++i;
            }
        }
    }
}

