/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.distributed;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.remoteservice.eventadmin.DistributedEventAdmin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class DistributedEventAdminActivator
implements BundleActivator {
    public static final String DEFAULT_TOPIC = "defaultTopic";
    protected BundleContext bundleContext;
    protected String containerType;
    protected String containerId;
    protected String targetId;
    protected String topic = "defaultTopic";
    protected ServiceTracker containerManagerTracker;
    protected DistributedEventAdmin eventAdminImpl;
    protected ServiceRegistration eventAdminRegistration;
    protected IContainer container;
    private static final String ECF_MANAGER_CONTAINER_TYPE = "ecf.jms.activemq.tcp.manager";
    public static final String ECF_MANAGER_CONTAINER_ID = "tcp://localhost:61616/exampleTopic";
    private static final String DEFAULT_CONTAINER_TYPE = "ecf.jms.activemq.tcp.client";

    public void start(BundleContext context) throws Exception {
        boolean isDistributed;
        String isDistributedStr = System.getProperty("isClustered");
        boolean bl = isDistributed = isDistributedStr != null ? Boolean.valueOf(isDistributedStr) : false;
        if (!isDistributed) {
            return;
        }
        this.bundleContext = context;
        this.containerId = ECF_MANAGER_CONTAINER_ID;
        this.containerId = System.getProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL");
        this.containerType = ECF_MANAGER_CONTAINER_TYPE;
        this.eventAdminImpl = new DistributedEventAdmin(this.bundleContext);
        try {
            this.containerId = ECF_MANAGER_CONTAINER_ID;
            this.containerType = ECF_MANAGER_CONTAINER_TYPE;
            if (System.getProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL") != null) {
                this.containerId = System.getProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL");
            }
            this.createConfigureAndConnectContainer();
        }
        catch (Throwable throwable) {
            this.containerId = null;
            this.containerType = DEFAULT_CONTAINER_TYPE;
            this.targetId = ECF_MANAGER_CONTAINER_ID;
            if (System.getProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL") != null) {
                this.targetId = System.getProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL");
            }
            this.topic = DEFAULT_TOPIC;
            this.createConfigureAndConnectContainer();
        }
        this.eventAdminImpl.start();
        Properties props = new Properties();
        props.put("event.topics", this.topic);
        props.put("eaType", "distributed");
        this.eventAdminRegistration = context.registerService("org.osgi.service.event.EventAdmin", (Object)this.eventAdminImpl, (Dictionary)props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.eventAdminRegistration != null) {
            this.eventAdminRegistration.unregister();
            this.eventAdminRegistration = null;
        }
        if (this.container != null) {
            this.container.dispose();
            this.getContainerManager().removeAllContainers();
            this.container = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
    }

    protected boolean isThereEventAdminManager() {
        IContainer[] containers = this.getContainerManager().getAllContainers();
        int i = 0;
        while (i < containers.length) {
            ISharedObjectContainer soContainer = (ISharedObjectContainer)containers[i].getAdapter(ISharedObjectContainer.class);
            if (soContainer != null && soContainer.isGroupManager()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createConfigureAndConnectContainer() throws ContainerCreateException, SharedObjectAddException, ContainerConnectException {
        IContainerFactory containerFactory = this.getContainerManager().getContainerFactory();
        this.container = this.containerId == null ? containerFactory.createContainer(this.containerType) : containerFactory.createContainer(this.containerType, new Object[]{this.containerId});
        ISharedObjectContainer soContainer = (ISharedObjectContainer)this.container.getAdapter(ISharedObjectContainer.class);
        soContainer.getSharedObjectManager().addSharedObject(IDFactory.getDefault().createStringID(this.topic), (ISharedObject)this.eventAdminImpl, null);
        if (soContainer.isGroupManager()) {
            System.out.println(" Event Admin " + soContainer);
        }
        if (this.targetId != null) {
            this.container.connect(IDFactory.getDefault().createID(this.container.getConnectNamespace(), this.targetId), null);
        }
    }

    protected IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(this.bundleContext, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

