/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.endpoints;

import java.util.Dictionary;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.eclipse.ebpm.connectors.jms.marshaler.DefaultProviderMarshaler;
import org.eclipse.ebpm.connectors.jms.marshaler.JmsProviderMarshaler;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.jms.connectionfactory.ConnectionFactory;
import org.eclipse.ebpm.jms.connectionfactory.IConnectionFactoryManager;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsProviderEndpoint
extends AbstractSpagicConnector {
    protected final AtomicReference<IConnectionFactoryManager> connectionFactoryManager = new AtomicReference<Object>(null);
    private JmsProviderMarshaler marshaler;
    private String connectionFactoryName;
    private String destinationName;
    private boolean pubSubDomain;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean needJavaIdentifiers;
    private ConnectionFactory connectionFactory;
    private Connection connection = null;
    private Session session = null;
    private Destination destination;
    private MessageProducer producer = null;
    private ConcurrentLinkedQueue<Exchange> waitingExchanges = new ConcurrentLinkedQueue();
    protected Logger logger = LoggerFactory.getLogger(JmsProviderEndpoint.class);

    public void init() {
        this.connectionFactoryName = this.propertyConfigurator.getString("connectionFactoryName");
        try {
            this.connectionFactory = this.getConnectionFactoryManager().getConnectionFactory(this.connectionFactoryName);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        this.destinationName = this.propertyConfigurator.getString("destinationName");
        this.messageIdEnabled = this.propertyConfigurator.getBoolean("messageIdEnabled", Boolean.valueOf(true));
        this.messageTimestampEnabled = this.propertyConfigurator.getBoolean("messageTimestampEnabled", Boolean.valueOf(true));
        this.needJavaIdentifiers = this.propertyConfigurator.getBoolean("needJavaIdentifiers", Boolean.valueOf(true));
        this.pubSubDomain = this.propertyConfigurator.getBoolean("pubSubDomain", Boolean.valueOf(true));
    }

    public IConnectionFactoryManager getConnectionFactoryManager() {
        return this.connectionFactoryManager.get();
    }

    public void setConnectionFactoryManager(IConnectionFactoryManager cfm) {
        this.connectionFactoryManager.set(cfm);
    }

    public void unsetConnectionFactoryManager(IConnectionFactoryManager cfm) {
        this.connectionFactoryManager.compareAndSet(cfm, null);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            JmsProviderEndpoint jmsProviderEndpoint = this;
            synchronized (jmsProviderEndpoint) {
                if (this.connectionFactory == null) {
                    try {
                        this.connectionFactory = this.getConnectionFactoryManager().getConnectionFactory(this.connectionFactoryName);
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage());
                    }
                }
            }
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsProviderMarshaler marshaler) {
        if (marshaler == null) {
            throw new NullPointerException("marshaler is null");
        }
        this.marshaler = marshaler;
        marshaler.setNeedJavaIdentifiers(this.needJavaIdentifiers);
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        try {
            if (this.getConnectionFactory() == null) {
                this.logger.info("Connection Factory still not available. Putting exchange in temporary queue");
                this.waitingExchanges.add(exchange);
                return false;
            }
            this.logger.info("Sending message with id: " + exchange.getId());
            javax.jms.Message message = this.marshaler.createMessage(exchange, in, this.session);
            this.producer.send(message);
            return true;
        }
        finally {
            in.finalizeAttachments();
        }
    }

    public void validate() {
        if (this.marshaler == null) {
            this.setMarshaler(this.createDefaultMarshaler());
        }
        if (this.destination == null && this.destinationName == null) {
            throw new RuntimeException("destination or destinationName is required");
        }
    }

    protected JmsProviderMarshaler createDefaultMarshaler() {
        return new DefaultProviderMarshaler();
    }

    public void start() throws Exception {
        this.validate();
        if (this.getConnectionFactory() == null) {
            return;
        }
        this.connection = this.getConnectionFactory().createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.getConnectionFactory().getDestination(this.pubSubDomain, this.destinationName);
        this.producer = this.session.createProducer(this.destination);
        this.producer.setDisableMessageTimestamp(!this.messageTimestampEnabled);
        this.producer.setDisableMessageID(!this.messageIdEnabled);
        super.start();
    }

    public void stop() throws Exception {
        block20: {
            block18: {
                block16: {
                    if (this.producer != null) {
                        try {
                            try {
                                this.producer.close();
                            }
                            catch (JMSException e1) {
                                this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                                this.producer = null;
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            this.producer = null;
                            throw throwable;
                        }
                        this.producer = null;
                    }
                }
                if (this.session != null) {
                    try {
                        try {
                            this.session.close();
                        }
                        catch (JMSException e1) {
                            this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                            this.session = null;
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        this.session = null;
                        throw throwable;
                    }
                    this.session = null;
                }
            }
            if (this.connection != null) {
                try {
                    try {
                        this.connection.stop();
                        this.connection.close();
                    }
                    catch (JMSException e1) {
                        this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                        this.connection = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.connection = null;
                    throw throwable;
                }
                this.connection = null;
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInternalEvent(Event event) {
        block16: {
            this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "] handle internal Event Start Event [" + event + "]");
            String evType = (String)event.getProperty("_INTERNAL_EVENT_TYPE");
            if (evType.equalsIgnoreCase("_INTERNAL_EVENT_CF_DEPLOYED")) {
                String id = (String)event.getProperty("_INTERNAL_EVENT_REFERRING_ID");
                this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::ConnectionFactory [" + id + "] Registered on ConnectionFactoryManager");
                try {
                    if (id.equals(this.connectionFactoryName)) {
                        this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::Reacting to ConnectionFactory[" + id + "] registration");
                        JmsProviderEndpoint jmsProviderEndpoint = this;
                        synchronized (jmsProviderEndpoint) {
                            this.connectionFactory = this.getConnectionFactoryManager().getConnectionFactory(this.connectionFactoryName);
                            this.start();
                            this.logger.info("Consuming " + this.waitingExchanges.size() + " stored exchanges");
                            Exchange storedExchange = null;
                            while ((storedExchange = this.waitingExchanges.poll()) != null) {
                                this.logger.info("Consuming exchange with id:" + storedExchange.getId());
                                this.run(storedExchange, storedExchange.getIn(), storedExchange.getOut());
                                this.done(storedExchange);
                            }
                            break block16;
                        }
                    }
                    this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::Discard ConnectionFactory[" + id + "] registration, interested in [" + this.connectionFactoryName + "]");
                    return;
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage());
                }
            } else if (evType.equalsIgnoreCase("_INTERNAL_EVENT_CF_UNDEPLOYED")) {
                String id = (String)event.getProperty("_INTERNAL_EVENT_REFERRING_ID");
                this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::ConnectionFactory [" + id + "] UnRegistered on ConnectionFactoryManager");
                if (id.equals(this.connectionFactoryName)) {
                    this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::Reacting to ConnectionFactory[" + id + "] UnRegistration");
                    JmsProviderEndpoint jmsProviderEndpoint = this;
                    synchronized (jmsProviderEndpoint) {
                        try {
                            this.stop();
                        }
                        catch (Exception exception) {
                            this.logger.error("JMSProviderEndpoint[" + this.getSpagicId() + "]::Error stopping component");
                        }
                    }
                }
                this.logger.info("JMSProviderEndpoint[" + this.getSpagicId() + "]::Discard ConnectionFactory[" + id + "] UnRegistration, interested in [" + this.connectionFactoryName + "]");
                return;
            }
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary propertiesDictionary = componentContext.getProperties();
        this.propertyConfigurator = new PropertyConfigurator(propertiesDictionary);
        this.spagicId = this.propertyConfigurator.getString("spagic.id");
        IConnectionFactoryManager cfManager = this.getConnectionFactoryManager();
        cfManager.registerForNotification(this.getSpagicId());
        super.activate(componentContext);
    }
}

