/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;
    private MessageContext context;
    private static boolean ignoreMultipartEncoding = true;

    static {
        try {
            String s = System.getProperty("mail.mime.ignoremultipartencoding");
            ignoreMultipartEncoding = s == null || !s.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {}
    }

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream is;
            if (this.part instanceof MimeBodyPart) {
                is = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                is = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String encoding = MimePartDataSource.restrictEncoding(this.part.getEncoding(), this.part);
            if (encoding != null) {
                return MimeUtility.decode(is, encoding);
            }
            return is;
        }
        catch (MessagingException mex) {
            throw new IOException(mex.getMessage());
        }
    }

    private static String restrictEncoding(String encoding, MimePart part) throws MessagingException {
        if (!ignoreMultipartEncoding || encoding == null) {
            return encoding;
        }
        if (encoding.equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit") || encoding.equalsIgnoreCase("binary")) {
            return encoding;
        }
        String type = part.getContentType();
        if (type == null) {
            return encoding;
        }
        try {
            ContentType cType = new ContentType(type);
            if (cType.match("multipart/*") || cType.match("message/*")) {
                return null;
            }
        }
        catch (ParseException parseException) {}
        return encoding;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException messagingException) {
            return "application/octet-stream";
        }
    }

    @Override
    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {}
        return "";
    }

    @Override
    public synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }
}

