/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.jms.Activator;
import org.eclipse.ecf.internal.provider.jms.Messages;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.ServerSOContainer;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSServerChannel;
import org.eclipse.ecf.provider.jms.channel.ConnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectRequestMessage;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;

public abstract class AbstractJMSServer
extends ServerSOContainer {
    public static final int DEFAULT_KEEPALIVE = 30000;
    private IConnectHandlerPolicy joinPolicy = null;
    private ISynchAsynchConnection serverChannel;

    public AbstractJMSServer(JMSContainerConfig config) {
        super((ISharedObjectContainerConfig)config);
    }

    public abstract void start() throws ECFException;

    protected JMSContainerConfig getJMSContainerConfig() {
        return (JMSContainerConfig)this.getConfig();
    }

    protected void setConnection(ISynchAsynchConnection channel) {
        this.serverChannel = channel;
    }

    protected ISynchAsynchConnection getConnection() {
        return this.serverChannel;
    }

    protected IConnectHandlerPolicy getConnectHandlerPolicy() {
        return this.joinPolicy;
    }

    protected void setConnectHandlerPolicy(IConnectHandlerPolicy policy) {
        this.joinPolicy = policy;
    }

    protected Serializable processSynch(SynchEvent e) throws IOException {
        DisconnectRequestMessage dcm;
        IAsynchConnection conn;
        Object req = e.getData();
        if (req instanceof ConnectRequestMessage) {
            return this.handleConnectRequest((ConnectRequestMessage)req, (AbstractJMSServerChannel)e.getConnection());
        }
        if (req instanceof DisconnectRequestMessage && (conn = this.getConnectionForID((dcm = (DisconnectRequestMessage)req).getSenderID())) != null && conn instanceof AbstractJMSServerChannel.Client) {
            AbstractJMSServerChannel.Client client = (AbstractJMSServerChannel.Client)conn;
            client.handleDisconnect();
        }
        return null;
    }

    protected void traceAndLogExceptionCatch(int code, String method, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)method, (Throwable)e);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", code, method, e));
    }

    protected void handleConnectException(ContainerMessage mess, AbstractJMSServerChannel serverChannel1, Exception e) {
    }

    protected Object checkJoin(SocketAddress socketAddress, ID fromID, String targetPath, Serializable data) throws Exception {
        if (this.joinPolicy != null) {
            return this.joinPolicy.checkConnect((Object)socketAddress, fromID, this.getID(), targetPath, (Object)data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable handleConnectRequest(ConnectRequestMessage request, AbstractJMSServerChannel channel) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"handleConnectRequest", (Object[])new Object[]{request, channel});
        try {
            ContainerMessage containerMessage = (ContainerMessage)request.getData();
            if (containerMessage == null) {
                throw new InvalidObjectException(Messages.AbstractJMSServer_CONNECT_EXCEPTION_CONTAINER_MESSAGE_NOT_NULL);
            }
            ID remoteID = containerMessage.getFromContainerID();
            if (remoteID == null) {
                throw new InvalidObjectException(Messages.AbstractJMSServer_CONNECT_EXCEPTION_REMOTEID_NOT_NULL);
            }
            ContainerMessage.JoinGroupMessage jgm = (ContainerMessage.JoinGroupMessage)containerMessage.getData();
            if (jgm == null) {
                throw new InvalidObjectException(Messages.AbstractJMSServer_CONNECT_EXCEPTION_JOINGROUPMESSAGE_NOT_NULL);
            }
            ID[] memberIDs = null;
            Serializable[] messages = new Serializable[2];
            AbstractJMSServerChannel.Client newclient = null;
            Object object = this.getGroupMembershipLock();
            synchronized (object) {
                if (this.isClosing) {
                    throw new ContainerConnectException(Messages.AbstractJMSServer_CONNECT_EXCEPTION_CONTAINER_CLOSING);
                }
                this.checkJoin(channel, remoteID, request.getTargetJMSID().getTopic(), jgm.getData());
                AbstractJMSServerChannel abstractJMSServerChannel = channel;
                abstractJMSServerChannel.getClass();
                newclient = abstractJMSServerChannel.new AbstractJMSServerChannel.Client(remoteID);
                if (!this.addNewRemoteMember(remoteID, newclient)) {
                    ConnectException e = new ConnectException(Messages.AbstractJMSServer_CONNECT_EXCEPTION_REFUSED);
                    throw e;
                }
                memberIDs = this.getGroupMemberIDs();
                messages[1] = AbstractJMSServer.serialize((Serializable)ContainerMessage.createViewChangeMessage((ID)this.getID(), null, (long)this.getNextSequenceNumber(), (ID[])new ID[]{remoteID}, (boolean)true, null));
            }
            this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), remoteID));
            messages[0] = AbstractJMSServer.serialize((Serializable)ContainerMessage.createViewChangeMessage((ID)this.getID(), (ID)remoteID, (long)this.getNextSequenceNumber(), (ID[])memberIDs, (boolean)true, null));
            newclient.start();
            return messages;
        }
        catch (Exception e) {
            this.traceAndLogExceptionCatch(4, "handleConnectRequest", e);
            return null;
        }
    }

    protected void forwardExcluding(ID from, ID excluding, ContainerMessage data) throws IOException {
    }

    protected void forwardToRemote(ID from, ID to, ContainerMessage data) throws IOException {
    }

    protected void queueContainerMessage(ContainerMessage mess) throws IOException {
        this.serverChannel.sendAsynch(mess.getToContainerID(), AbstractJMSServer.serialize((Serializable)mess));
    }

    protected void handleLeave(ID target, IConnection conn) {
        if (target == null) {
            return;
        }
        if (this.removeRemoteMember(target)) {
            try {
                this.queueContainerMessage(ContainerMessage.createViewChangeMessage((ID)this.getID(), null, (long)this.getNextSequenceNumber(), (ID[])new ID[]{target}, (boolean)false, null));
            }
            catch (IOException e) {
                this.traceAndLogExceptionCatch(4, "memberLeave", e);
            }
        }
        if (conn != null) {
            this.disconnect(conn);
        }
    }
}

