/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.channel;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.jms.Messages;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.comm.ISynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSChannel;
import org.eclipse.ecf.provider.jms.channel.ConnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.ConnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectRequestMessage;
import org.eclipse.ecf.provider.jms.channel.DisconnectResponseMessage;
import org.eclipse.ecf.provider.jms.channel.ECFMessage;
import org.eclipse.ecf.provider.jms.channel.Ping;
import org.eclipse.ecf.provider.jms.channel.PingResponse;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractJMSClientChannel
extends AbstractJMSChannel
implements ISynchAsynchConnection {
    private static final long serialVersionUID = -1381571376210849678L;
    private static final int RESPOND_TO_REQUEST_ERROR_CODE = 32001;
    private static final int DEFAULT_DISCONNECT_WAIT_TIME = 3000;
    private final int disconnectWaitTime = 3000;

    public AbstractJMSClientChannel(ISynchAsynchEventHandler handler, int keepAlive) {
        super(handler, keepAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object connect(ID target, Object data, int timeout) throws ECFException {
        Object object = this.synch;
        synchronized (object) {
            Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"connect", (Object[])new Object[]{target, data, new Integer(timeout)});
            if (this.isConnected()) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_ALREADY_CONNECTED);
            }
            if (target == null) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_TARGET_NOT_NULL);
            }
            if (!(target instanceof JMSID)) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_TARGET_NOT_JMSID);
            }
            if (!(data instanceof Serializable)) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_CONNECT_ERROR, (Throwable)new NotSerializableException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_NOT_SERIALIZABLE));
            }
            Serializable result = null;
            try {
                Serializable connectData = this.setupJMS((JMSID)target, data);
                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)("connecting to " + target + "," + data + "," + timeout + ")"));
                result = this.getConnectResult((JMSID)target, connectData);
            }
            catch (ECFException e) {
                ECFException except = e;
                throw new ContainerConnectException(except.getStatus());
            }
            catch (Exception e) {
                throw new ContainerConnectException(NLS.bind((String)Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_CONNECT_FAILED, (Object)target.getName()), (Throwable)e);
            }
            if (result == null) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_TARGET_REFUSED_CONNECTION);
            }
            if (!(result instanceof ConnectResponseMessage)) {
                throw new ContainerConnectException(Messages.AbstractJMSClientChannel_CONNECT_EXCEPTION_INVALID_RESPONSE);
            }
            Serializable resultData = ((ConnectResponseMessage)result).getData();
            this.fireListenersConnect(new ConnectionEvent((IConnection)this, (Object)resultData));
            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"connect", (Object)resultData);
            return resultData;
        }
    }

    protected Serializable getConnectResult(JMSID managerID, Serializable data) throws IOException {
        return this.sendAndWait(new ConnectRequestMessage(this.getConnectionID(), this.getLocalID(), managerID, data));
    }

    protected void handleSynchRequest(ObjectMessage omsg, ECFMessage o) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"respondToRequest", (Object[])new Object[]{omsg, o});
        boolean active = this.isActive();
        try {
            if (o instanceof DisconnectRequestMessage) {
                ObjectMessage response = this.session.createObjectMessage((Serializable)new DisconnectResponseMessage(this.getConnectionID(), o.getTargetID(), o.getSenderID(), null));
                response.setJMSCorrelationID(omsg.getJMSCorrelationID());
                this.jmsTopic.getProducer().send((Message)response);
                if (active) {
                    this.handler.handleSynchEvent(new SynchEvent((ISynchConnection)this, (Object)o.getData()));
                }
            } else if (o instanceof Ping && active) {
                ObjectMessage response = this.session.createObjectMessage((Serializable)new PingResponse(o.getTargetID(), o.getSenderID()));
                response.setJMSCorrelationID(omsg.getJMSCorrelationID());
                this.jmsTopic.getProducer().send((Message)response);
            }
        }
        catch (Exception e) {
            this.traceAndLogExceptionCatch(32001, "respondToRequest", e);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"respondToRequest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendSynch(ID target, byte[] data) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendSynch", (Object[])new Object[]{target, data});
        Serializable result = null;
        boolean active = true;
        Object object = this.synch;
        synchronized (object) {
            active = this.isActive();
            if (active) {
                this.isStopping = true;
            }
        }
        if (active) {
            result = this.sendAndWait(new DisconnectRequestMessage(this.getConnectionID(), this.getLocalID(), target, (Serializable)data), 3000);
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendSynch", result);
        return result;
    }
}

