/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeEnumeration<T>
implements Enumeration<T> {
    private Enumeration<T> currentEnumeration;
    private Iterator<Enumeration<T>> enumerationIterator;

    public CompositeEnumeration(List<Enumeration<T>> enumerations) {
        this.enumerationIterator = enumerations.iterator();
        this.currentEnumeration = this.enumerationIterator.hasNext() ? this.enumerationIterator.next() : new NullObjectEnumeration();
    }

    @Override
    public boolean hasMoreElements() {
        boolean hasMoreElements = this.currentEnumeration.hasMoreElements();
        if (hasMoreElements) {
            return true;
        }
        if (this.enumerationIterator.hasNext()) {
            this.currentEnumeration = this.enumerationIterator.next();
            return this.hasMoreElements();
        }
        return false;
    }

    @Override
    public T nextElement() {
        return this.currentEnumeration.nextElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NullObjectEnumeration
    implements Enumeration<T> {
        private NullObjectEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

